/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AnalyticsQueryAggregation;
import com.mypurecloud.sdk.v2.model.ConversationDetailQueryFilter;
import com.mypurecloud.sdk.v2.model.EvaluationDetailQueryFilter;
import com.mypurecloud.sdk.v2.model.PagingSpec;
import com.mypurecloud.sdk.v2.model.ResolutionDetailQueryFilter;
import com.mypurecloud.sdk.v2.model.SegmentDetailQueryFilter;
import com.mypurecloud.sdk.v2.model.SurveyDetailQueryFilter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ConversationQuery
implements Serializable {
    private List<ConversationDetailQueryFilter> conversationFilters = null;
    private List<SegmentDetailQueryFilter> segmentFilters = null;
    private List<EvaluationDetailQueryFilter> evaluationFilters = null;
    private List<SurveyDetailQueryFilter> surveyFilters = null;
    private List<ResolutionDetailQueryFilter> resolutionFilters = null;
    private OrderEnum order = null;
    private OrderByEnum orderBy = null;
    private String interval = null;
    private List<AnalyticsQueryAggregation> aggregations = null;
    private PagingSpec paging = null;

    public ConversationQuery() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.conversationFilters = new ArrayList<ConversationDetailQueryFilter>();
            this.segmentFilters = new ArrayList<SegmentDetailQueryFilter>();
            this.evaluationFilters = new ArrayList<EvaluationDetailQueryFilter>();
            this.surveyFilters = new ArrayList<SurveyDetailQueryFilter>();
            this.resolutionFilters = new ArrayList<ResolutionDetailQueryFilter>();
            this.aggregations = new ArrayList<AnalyticsQueryAggregation>();
        }
    }

    public ConversationQuery conversationFilters(List<ConversationDetailQueryFilter> conversationFilters) {
        this.conversationFilters = conversationFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target conversation-level data")
    @JsonProperty(value="conversationFilters")
    public List<ConversationDetailQueryFilter> getConversationFilters() {
        return this.conversationFilters;
    }

    public void setConversationFilters(List<ConversationDetailQueryFilter> conversationFilters) {
        this.conversationFilters = conversationFilters;
    }

    public ConversationQuery segmentFilters(List<SegmentDetailQueryFilter> segmentFilters) {
        this.segmentFilters = segmentFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target individual segments within a conversation")
    @JsonProperty(value="segmentFilters")
    public List<SegmentDetailQueryFilter> getSegmentFilters() {
        return this.segmentFilters;
    }

    public void setSegmentFilters(List<SegmentDetailQueryFilter> segmentFilters) {
        this.segmentFilters = segmentFilters;
    }

    public ConversationQuery evaluationFilters(List<EvaluationDetailQueryFilter> evaluationFilters) {
        this.evaluationFilters = evaluationFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target evaluations")
    @JsonProperty(value="evaluationFilters")
    public List<EvaluationDetailQueryFilter> getEvaluationFilters() {
        return this.evaluationFilters;
    }

    public void setEvaluationFilters(List<EvaluationDetailQueryFilter> evaluationFilters) {
        this.evaluationFilters = evaluationFilters;
    }

    public ConversationQuery surveyFilters(List<SurveyDetailQueryFilter> surveyFilters) {
        this.surveyFilters = surveyFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target surveys")
    @JsonProperty(value="surveyFilters")
    public List<SurveyDetailQueryFilter> getSurveyFilters() {
        return this.surveyFilters;
    }

    public void setSurveyFilters(List<SurveyDetailQueryFilter> surveyFilters) {
        this.surveyFilters = surveyFilters;
    }

    public ConversationQuery resolutionFilters(List<ResolutionDetailQueryFilter> resolutionFilters) {
        this.resolutionFilters = resolutionFilters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters that target resolutions")
    @JsonProperty(value="resolutionFilters")
    public List<ResolutionDetailQueryFilter> getResolutionFilters() {
        return this.resolutionFilters;
    }

    public void setResolutionFilters(List<ResolutionDetailQueryFilter> resolutionFilters) {
        this.resolutionFilters = resolutionFilters;
    }

    public ConversationQuery order(OrderEnum order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(example="null", value="Sort the result set in ascending/descending order. Default is ascending")
    @JsonProperty(value="order")
    public OrderEnum getOrder() {
        return this.order;
    }

    public void setOrder(OrderEnum order) {
        this.order = order;
    }

    public ConversationQuery orderBy(OrderByEnum orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    @ApiModelProperty(example="null", value="Specify which data element within the result set to use for sorting. The options  to use as a basis for sorting the results: conversationStart, segmentStart, and segmentEnd. If not specified, the default is conversationStart")
    @JsonProperty(value="orderBy")
    public OrderByEnum getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(OrderByEnum orderBy) {
        this.orderBy = orderBy;
    }

    public ConversationQuery interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Specifies the date and time range of data being queried. Results will only include conversations that started on a day touched by the interval. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public ConversationQuery aggregations(List<AnalyticsQueryAggregation> aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    @ApiModelProperty(example="null", value="Include faceted search and aggregate roll-ups describing your search results. This does not function as a filter, but rather, summary data about the data matching your filters")
    @JsonProperty(value="aggregations")
    public List<AnalyticsQueryAggregation> getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(List<AnalyticsQueryAggregation> aggregations) {
        this.aggregations = aggregations;
    }

    public ConversationQuery paging(PagingSpec paging) {
        this.paging = paging;
        return this;
    }

    @ApiModelProperty(example="null", value="Page size and number to control iterating through large result sets. Default page size is 25")
    @JsonProperty(value="paging")
    public PagingSpec getPaging() {
        return this.paging;
    }

    public void setPaging(PagingSpec paging) {
        this.paging = paging;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationQuery conversationQuery = (ConversationQuery)o;
        return Objects.equals(this.conversationFilters, conversationQuery.conversationFilters) && Objects.equals(this.segmentFilters, conversationQuery.segmentFilters) && Objects.equals(this.evaluationFilters, conversationQuery.evaluationFilters) && Objects.equals(this.surveyFilters, conversationQuery.surveyFilters) && Objects.equals(this.resolutionFilters, conversationQuery.resolutionFilters) && Objects.equals((Object)this.order, (Object)conversationQuery.order) && Objects.equals((Object)this.orderBy, (Object)conversationQuery.orderBy) && Objects.equals(this.interval, conversationQuery.interval) && Objects.equals(this.aggregations, conversationQuery.aggregations) && Objects.equals(this.paging, conversationQuery.paging);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conversationFilters, this.segmentFilters, this.evaluationFilters, this.surveyFilters, this.resolutionFilters, this.order, this.orderBy, this.interval, this.aggregations, this.paging});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationQuery {\n");
        sb.append("    conversationFilters: ").append(this.toIndentedString(this.conversationFilters)).append("\n");
        sb.append("    segmentFilters: ").append(this.toIndentedString(this.segmentFilters)).append("\n");
        sb.append("    evaluationFilters: ").append(this.toIndentedString(this.evaluationFilters)).append("\n");
        sb.append("    surveyFilters: ").append(this.toIndentedString(this.surveyFilters)).append("\n");
        sb.append("    resolutionFilters: ").append(this.toIndentedString(this.resolutionFilters)).append("\n");
        sb.append("    order: ").append(this.toIndentedString((Object)this.order)).append("\n");
        sb.append("    orderBy: ").append(this.toIndentedString((Object)this.orderBy)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    aggregations: ").append(this.toIndentedString(this.aggregations)).append("\n");
        sb.append("    paging: ").append(this.toIndentedString(this.paging)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OrderEnumDeserializer.class)
    public static enum OrderEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASC("asc"),
        DESC("desc"),
        UNORDERED("unordered");

        private String value;

        private OrderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OrderEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OrderEnum value : OrderEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OrderEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=OrderByEnumDeserializer.class)
    public static enum OrderByEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CONVERSATIONSTART("conversationStart"),
        CONVERSATIONEND("conversationEnd"),
        SEGMENTSTART("segmentStart"),
        SEGMENTEND("segmentEnd");

        private String value;

        private OrderByEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OrderByEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OrderByEnum value : OrderByEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OrderByEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OrderByEnumDeserializer
    extends StdDeserializer<OrderByEnum> {
        public OrderByEnumDeserializer() {
            super(OrderByEnumDeserializer.class);
        }

        public OrderByEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OrderByEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class OrderEnumDeserializer
    extends StdDeserializer<OrderEnum> {
        public OrderEnumDeserializer() {
            super(OrderEnumDeserializer.class);
        }

        public OrderEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OrderEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

