/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class TransferToExternalContactRequest
implements Serializable {
    private TransferTypeEnum transferType = null;
    private Boolean keepInternalMessageAlive = null;
    private String contactId = null;
    private PhoneTypeEnum phoneType = null;

    public TransferToExternalContactRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public TransferToExternalContactRequest transferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of transfer to perform. Attended, where the initiating agent maintains ownership of the conversation until the intended recipient accepts the transfer, or Unattended, where the initiating agent immediately disconnects. Default is Unattended.")
    @JsonProperty(value="transferType")
    public TransferTypeEnum getTransferType() {
        return this.transferType;
    }

    public void setTransferType(TransferTypeEnum transferType) {
        this.transferType = transferType;
    }

    public TransferToExternalContactRequest keepInternalMessageAlive(Boolean keepInternalMessageAlive) {
        this.keepInternalMessageAlive = keepInternalMessageAlive;
        return this;
    }

    @ApiModelProperty(example="null", value="If true, the digital internal message will NOT be terminated.")
    @JsonProperty(value="keepInternalMessageAlive")
    public Boolean getKeepInternalMessageAlive() {
        return this.keepInternalMessageAlive;
    }

    public void setKeepInternalMessageAlive(Boolean keepInternalMessageAlive) {
        this.keepInternalMessageAlive = keepInternalMessageAlive;
    }

    public TransferToExternalContactRequest contactId(String contactId) {
        this.contactId = contactId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The external contact id.")
    @JsonProperty(value="contactId")
    public String getContactId() {
        return this.contactId;
    }

    public void setContactId(String contactId) {
        this.contactId = contactId;
    }

    public TransferToExternalContactRequest phoneType(PhoneTypeEnum phoneType) {
        this.phoneType = phoneType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The external contact phone type.")
    @JsonProperty(value="phoneType")
    public PhoneTypeEnum getPhoneType() {
        return this.phoneType;
    }

    public void setPhoneType(PhoneTypeEnum phoneType) {
        this.phoneType = phoneType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferToExternalContactRequest transferToExternalContactRequest = (TransferToExternalContactRequest)o;
        return Objects.equals((Object)this.transferType, (Object)transferToExternalContactRequest.transferType) && Objects.equals(this.keepInternalMessageAlive, transferToExternalContactRequest.keepInternalMessageAlive) && Objects.equals(this.contactId, transferToExternalContactRequest.contactId) && Objects.equals((Object)this.phoneType, (Object)transferToExternalContactRequest.phoneType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transferType, this.keepInternalMessageAlive, this.contactId, this.phoneType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferToExternalContactRequest {\n");
        sb.append("    transferType: ").append(this.toIndentedString((Object)this.transferType)).append("\n");
        sb.append("    keepInternalMessageAlive: ").append(this.toIndentedString(this.keepInternalMessageAlive)).append("\n");
        sb.append("    contactId: ").append(this.toIndentedString(this.contactId)).append("\n");
        sb.append("    phoneType: ").append(this.toIndentedString((Object)this.phoneType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TransferTypeEnumDeserializer.class)
    public static enum TransferTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ATTENDED("Attended"),
        UNATTENDED("Unattended");

        private String value;

        private TransferTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TransferTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TransferTypeEnum value : TransferTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TransferTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=PhoneTypeEnumDeserializer.class)
    public static enum PhoneTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WORKPHONE("WorkPhone"),
        CELLPHONE("CellPhone"),
        HOMEPHONE("HomePhone"),
        OTHERPHONE("OtherPhone");

        private String value;

        private PhoneTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PhoneTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PhoneTypeEnum value : PhoneTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PhoneTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class PhoneTypeEnumDeserializer
    extends StdDeserializer<PhoneTypeEnum> {
        public PhoneTypeEnumDeserializer() {
            super(PhoneTypeEnumDeserializer.class);
        }

        public PhoneTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PhoneTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TransferTypeEnumDeserializer
    extends StdDeserializer<TransferTypeEnum> {
        public TransferTypeEnumDeserializer() {
            super(TransferTypeEnumDeserializer.class);
        }

        public TransferTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TransferTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

