/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Learning assignment SCO (Shareable Content Object)")
public class LearningShareableContentObject
implements Serializable {
    private String id = null;
    private LessonStatusEnum lessonStatus = null;
    private ExitEnum exit = null;
    private String location = null;
    private Float scoreRaw = null;
    private Float scoreMax = null;
    private Float scoreMin = null;
    private String suspendData = null;
    private CreditEnum credit = null;
    private EntryEnum entry = null;
    private ModeEnum mode = null;
    private String totalTime = null;
    private String sessionTime = null;
    private String href = null;
    private String parameters = null;
    private String launchData = null;

    public LearningShareableContentObject() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public LearningShareableContentObject id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the SCO from the course manifest.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LearningShareableContentObject lessonStatus(LessonStatusEnum lessonStatus) {
        this.lessonStatus = lessonStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the SCO. Maps to the SCORM 1.2 cmi.core.lesson_status property.")
    @JsonProperty(value="lessonStatus")
    public LessonStatusEnum getLessonStatus() {
        return this.lessonStatus;
    }

    public void setLessonStatus(LessonStatusEnum lessonStatus) {
        this.lessonStatus = lessonStatus;
    }

    public LearningShareableContentObject exit(ExitEnum exit) {
        this.exit = exit;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates how or why the learner left the SCO. Maps to the SCORM 1.2 cmi.core.exit property.")
    @JsonProperty(value="exit")
    public ExitEnum getExit() {
        return this.exit;
    }

    public void setExit(ExitEnum exit) {
        this.exit = exit;
    }

    public LearningShareableContentObject location(String location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(example="null", value="The learner\u2019s current location in the SCO. Maps to the SCORM 1.2 cmi.core.lesson_location property.")
    @JsonProperty(value="location")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public LearningShareableContentObject scoreRaw(Float scoreRaw) {
        this.scoreRaw = scoreRaw;
        return this;
    }

    @ApiModelProperty(example="null", value="The score of the most recent attempt on the SCO. Maps to the SCORM 1.2 cmi.core.score.raw property.")
    @JsonProperty(value="scoreRaw")
    public Float getScoreRaw() {
        return this.scoreRaw;
    }

    public void setScoreRaw(Float scoreRaw) {
        this.scoreRaw = scoreRaw;
    }

    public LearningShareableContentObject scoreMax(Float scoreMax) {
        this.scoreMax = scoreMax;
        return this;
    }

    @ApiModelProperty(example="null", value="The maximum score that could be achieved on the SCO. Maps to the SCORM 1.2 cmi.core.score.max property.")
    @JsonProperty(value="scoreMax")
    public Float getScoreMax() {
        return this.scoreMax;
    }

    public void setScoreMax(Float scoreMax) {
        this.scoreMax = scoreMax;
    }

    public LearningShareableContentObject scoreMin(Float scoreMin) {
        this.scoreMin = scoreMin;
        return this;
    }

    @ApiModelProperty(example="null", value="The minimum score that could be achieved on the SCO. Maps to the SCORM 1.2 cmi.core.score.min property.")
    @JsonProperty(value="scoreMin")
    public Float getScoreMin() {
        return this.scoreMin;
    }

    public void setScoreMin(Float scoreMin) {
        this.scoreMin = scoreMin;
    }

    public LearningShareableContentObject suspendData(String suspendData) {
        this.suspendData = suspendData;
        return this;
    }

    @ApiModelProperty(example="null", value="The unique information generated by the SCO from previous uses. Maps to the SCORM 1.2 cmi.suspend_data property.")
    @JsonProperty(value="suspendData")
    public String getSuspendData() {
        return this.suspendData;
    }

    public void setSuspendData(String suspendData) {
        this.suspendData = suspendData;
    }

    @ApiModelProperty(example="null", value="Whether completing this course counts towards the overall assignment. Maps to the SCORM 1.2 cmi.core.credit property.")
    @JsonProperty(value="credit")
    public CreditEnum getCredit() {
        return this.credit;
    }

    @ApiModelProperty(example="null", value="Whether the learner has previously accessed this SCO. Maps to the SCORM 1.2 cmi.core.entry property.")
    @JsonProperty(value="entry")
    public EntryEnum getEntry() {
        return this.entry;
    }

    @ApiModelProperty(example="null", value="Identifies the mode in which the SCO should be presented to the learner. Maps to the SCORM 1.2 cmi.core.lesson_mode property.")
    @JsonProperty(value="mode")
    public ModeEnum getMode() {
        return this.mode;
    }

    @ApiModelProperty(example="null", value="The total amount of time the learner has spent in the SCO expressed as an ISO 8601 Duration, for example PT2H10M3.5S. Maps to the SCORM 1.2 cmi.core.total_time property.")
    @JsonProperty(value="totalTime")
    public String getTotalTime() {
        return this.totalTime;
    }

    public LearningShareableContentObject sessionTime(String sessionTime) {
        this.sessionTime = sessionTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The amount of time spent in the SCO in this session expressed as an ISO-8601 Duration, for example PT2H10M3.5S. Maps to the SCORM 1.2 cmi.core.session_time property.")
    @JsonProperty(value="sessionTime")
    public String getSessionTime() {
        return this.sessionTime;
    }

    public void setSessionTime(String sessionTime) {
        this.sessionTime = sessionTime;
    }

    @ApiModelProperty(example="null", value="The href from the course manifest for this SCO.")
    @JsonProperty(value="href")
    public String getHref() {
        return this.href;
    }

    @ApiModelProperty(example="null", value="The parameters from the course manifest for this SCO.")
    @JsonProperty(value="parameters")
    public String getParameters() {
        return this.parameters;
    }

    @ApiModelProperty(example="null", value="The launch data from the course manifest for this SCO.")
    @JsonProperty(value="launchData")
    public String getLaunchData() {
        return this.launchData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LearningShareableContentObject learningShareableContentObject = (LearningShareableContentObject)o;
        return Objects.equals(this.id, learningShareableContentObject.id) && Objects.equals((Object)this.lessonStatus, (Object)learningShareableContentObject.lessonStatus) && Objects.equals((Object)this.exit, (Object)learningShareableContentObject.exit) && Objects.equals(this.location, learningShareableContentObject.location) && Objects.equals(this.scoreRaw, learningShareableContentObject.scoreRaw) && Objects.equals(this.scoreMax, learningShareableContentObject.scoreMax) && Objects.equals(this.scoreMin, learningShareableContentObject.scoreMin) && Objects.equals(this.suspendData, learningShareableContentObject.suspendData) && Objects.equals((Object)this.credit, (Object)learningShareableContentObject.credit) && Objects.equals((Object)this.entry, (Object)learningShareableContentObject.entry) && Objects.equals((Object)this.mode, (Object)learningShareableContentObject.mode) && Objects.equals(this.totalTime, learningShareableContentObject.totalTime) && Objects.equals(this.sessionTime, learningShareableContentObject.sessionTime) && Objects.equals(this.href, learningShareableContentObject.href) && Objects.equals(this.parameters, learningShareableContentObject.parameters) && Objects.equals(this.launchData, learningShareableContentObject.launchData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.lessonStatus, this.exit, this.location, this.scoreRaw, this.scoreMax, this.scoreMin, this.suspendData, this.credit, this.entry, this.mode, this.totalTime, this.sessionTime, this.href, this.parameters, this.launchData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LearningShareableContentObject {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lessonStatus: ").append(this.toIndentedString((Object)this.lessonStatus)).append("\n");
        sb.append("    exit: ").append(this.toIndentedString((Object)this.exit)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    scoreRaw: ").append(this.toIndentedString(this.scoreRaw)).append("\n");
        sb.append("    scoreMax: ").append(this.toIndentedString(this.scoreMax)).append("\n");
        sb.append("    scoreMin: ").append(this.toIndentedString(this.scoreMin)).append("\n");
        sb.append("    suspendData: ").append(this.toIndentedString(this.suspendData)).append("\n");
        sb.append("    credit: ").append(this.toIndentedString((Object)this.credit)).append("\n");
        sb.append("    entry: ").append(this.toIndentedString((Object)this.entry)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    totalTime: ").append(this.toIndentedString(this.totalTime)).append("\n");
        sb.append("    sessionTime: ").append(this.toIndentedString(this.sessionTime)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    launchData: ").append(this.toIndentedString(this.launchData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=LessonStatusEnumDeserializer.class)
    public static enum LessonStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PASSED("Passed"),
        COMPLETED("Completed"),
        FAILED("Failed"),
        INCOMPLETE("Incomplete"),
        BROWSED("Browsed"),
        NOTATTEMPTED("NotAttempted");

        private String value;

        private LessonStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LessonStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LessonStatusEnum value : LessonStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LessonStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ExitEnumDeserializer.class)
    public static enum ExitEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TIMEOUT("Timeout"),
        SUSPEND("Suspend"),
        LOGOUT("Logout"),
        EMPTY("Empty");

        private String value;

        private ExitEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ExitEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ExitEnum value : ExitEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ExitEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=CreditEnumDeserializer.class)
    public static enum CreditEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CREDIT("Credit"),
        NOCREDIT("NoCredit");

        private String value;

        private CreditEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CreditEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CreditEnum value : CreditEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CreditEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=EntryEnumDeserializer.class)
    public static enum EntryEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ABINITIO("AbInitio"),
        RESUME("Resume"),
        EMPTY("Empty");

        private String value;

        private EntryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EntryEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EntryEnum value : EntryEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EntryEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ModeEnumDeserializer.class)
    public static enum ModeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BROWSE("Browse"),
        NORMAL("Normal"),
        REVIEW("Review");

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ModeEnum value : ModeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ModeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ModeEnumDeserializer
    extends StdDeserializer<ModeEnum> {
        public ModeEnumDeserializer() {
            super(ModeEnumDeserializer.class);
        }

        public ModeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ModeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class EntryEnumDeserializer
    extends StdDeserializer<EntryEnum> {
        public EntryEnumDeserializer() {
            super(EntryEnumDeserializer.class);
        }

        public EntryEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return EntryEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class CreditEnumDeserializer
    extends StdDeserializer<CreditEnum> {
        public CreditEnumDeserializer() {
            super(CreditEnumDeserializer.class);
        }

        public CreditEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CreditEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ExitEnumDeserializer
    extends StdDeserializer<ExitEnum> {
        public ExitEnumDeserializer() {
            super(ExitEnumDeserializer.class);
        }

        public ExitEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ExitEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class LessonStatusEnumDeserializer
    extends StdDeserializer<LessonStatusEnum> {
        public LessonStatusEnumDeserializer() {
            super(LessonStatusEnumDeserializer.class);
        }

        public LessonStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return LessonStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

