/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AiAnswer;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EvaluationQuestionScore
implements Serializable {
    private String questionId = null;
    private String answerId = null;
    private Integer score = null;
    private Boolean markedNA = null;
    private Boolean systemMarkedNA = null;
    private String assistedAnswerId = null;
    private Boolean failedKillQuestion = null;
    private String comments = null;
    private AiAnswer aiAnswer = null;
    private List<EvaluationQuestionScore> multipleSelectQuestionOptionScores = null;

    public EvaluationQuestionScore() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.multipleSelectQuestionOptionScores = new ArrayList<EvaluationQuestionScore>();
        }
    }

    public EvaluationQuestionScore questionId(String questionId) {
        this.questionId = questionId;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="questionId")
    public String getQuestionId() {
        return this.questionId;
    }

    public void setQuestionId(String questionId) {
        this.questionId = questionId;
    }

    public EvaluationQuestionScore answerId(String answerId) {
        this.answerId = answerId;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="answerId")
    public String getAnswerId() {
        return this.answerId;
    }

    public void setAnswerId(String answerId) {
        this.answerId = answerId;
    }

    public EvaluationQuestionScore score(Integer score) {
        this.score = score;
        return this;
    }

    @ApiModelProperty(example="null", value="Unweighted score of the question")
    @JsonProperty(value="score")
    public Integer getScore() {
        return this.score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public EvaluationQuestionScore markedNA(Boolean markedNA) {
        this.markedNA = markedNA;
        return this;
    }

    @ApiModelProperty(example="null", value="True when the evaluation is submitted with a question that does not have an answer. Only allowed when naEnabled is true or if set by the system")
    @JsonProperty(value="markedNA")
    public Boolean getMarkedNA() {
        return this.markedNA;
    }

    public void setMarkedNA(Boolean markedNA) {
        this.markedNA = markedNA;
    }

    public EvaluationQuestionScore systemMarkedNA(Boolean systemMarkedNA) {
        this.systemMarkedNA = systemMarkedNA;
        return this;
    }

    @ApiModelProperty(example="null", value="If markedNA is true, systemMarkedNA indicates whether it was marked by a user or by the system due to visibility conditions. Always false if markedNA is false.")
    @JsonProperty(value="systemMarkedNA")
    public Boolean getSystemMarkedNA() {
        return this.systemMarkedNA;
    }

    public void setSystemMarkedNA(Boolean systemMarkedNA) {
        this.systemMarkedNA = systemMarkedNA;
    }

    public EvaluationQuestionScore assistedAnswerId(String assistedAnswerId) {
        this.assistedAnswerId = assistedAnswerId;
        return this;
    }

    @ApiModelProperty(example="null", value="AnswerId found with evaluation assistance conditions")
    @JsonProperty(value="assistedAnswerId")
    public String getAssistedAnswerId() {
        return this.assistedAnswerId;
    }

    public void setAssistedAnswerId(String assistedAnswerId) {
        this.assistedAnswerId = assistedAnswerId;
    }

    public EvaluationQuestionScore failedKillQuestion(Boolean failedKillQuestion) {
        this.failedKillQuestion = failedKillQuestion;
        return this;
    }

    @ApiModelProperty(example="null", value="Applicable only on fatal questions. Indicates that the answer selected was not the highest score available for the question")
    @JsonProperty(value="failedKillQuestion")
    public Boolean getFailedKillQuestion() {
        return this.failedKillQuestion;
    }

    public void setFailedKillQuestion(Boolean failedKillQuestion) {
        this.failedKillQuestion = failedKillQuestion;
    }

    public EvaluationQuestionScore comments(String comments) {
        this.comments = comments;
        return this;
    }

    @ApiModelProperty(example="null", value="Comments from the evaluator specific to this question")
    @JsonProperty(value="comments")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @ApiModelProperty(example="null", value="Suggested AI answer")
    @JsonProperty(value="aiAnswer")
    public AiAnswer getAiAnswer() {
        return this.aiAnswer;
    }

    public EvaluationQuestionScore multipleSelectQuestionOptionScores(List<EvaluationQuestionScore> multipleSelectQuestionOptionScores) {
        this.multipleSelectQuestionOptionScores = multipleSelectQuestionOptionScores;
        return this;
    }

    @ApiModelProperty(example="null", value="Only applicable to Multiple Select questions. Scores corresponding to the options of Multiple Select questions.")
    @JsonProperty(value="multipleSelectQuestionOptionScores")
    public List<EvaluationQuestionScore> getMultipleSelectQuestionOptionScores() {
        return this.multipleSelectQuestionOptionScores;
    }

    public void setMultipleSelectQuestionOptionScores(List<EvaluationQuestionScore> multipleSelectQuestionOptionScores) {
        this.multipleSelectQuestionOptionScores = multipleSelectQuestionOptionScores;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluationQuestionScore evaluationQuestionScore = (EvaluationQuestionScore)o;
        return Objects.equals(this.questionId, evaluationQuestionScore.questionId) && Objects.equals(this.answerId, evaluationQuestionScore.answerId) && Objects.equals(this.score, evaluationQuestionScore.score) && Objects.equals(this.markedNA, evaluationQuestionScore.markedNA) && Objects.equals(this.systemMarkedNA, evaluationQuestionScore.systemMarkedNA) && Objects.equals(this.assistedAnswerId, evaluationQuestionScore.assistedAnswerId) && Objects.equals(this.failedKillQuestion, evaluationQuestionScore.failedKillQuestion) && Objects.equals(this.comments, evaluationQuestionScore.comments) && Objects.equals(this.aiAnswer, evaluationQuestionScore.aiAnswer) && Objects.equals(this.multipleSelectQuestionOptionScores, evaluationQuestionScore.multipleSelectQuestionOptionScores);
    }

    public int hashCode() {
        return Objects.hash(this.questionId, this.answerId, this.score, this.markedNA, this.systemMarkedNA, this.assistedAnswerId, this.failedKillQuestion, this.comments, this.aiAnswer, this.multipleSelectQuestionOptionScores);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EvaluationQuestionScore {\n");
        sb.append("    questionId: ").append(this.toIndentedString(this.questionId)).append("\n");
        sb.append("    answerId: ").append(this.toIndentedString(this.answerId)).append("\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("    markedNA: ").append(this.toIndentedString(this.markedNA)).append("\n");
        sb.append("    systemMarkedNA: ").append(this.toIndentedString(this.systemMarkedNA)).append("\n");
        sb.append("    assistedAnswerId: ").append(this.toIndentedString(this.assistedAnswerId)).append("\n");
        sb.append("    failedKillQuestion: ").append(this.toIndentedString(this.failedKillQuestion)).append("\n");
        sb.append("    comments: ").append(this.toIndentedString(this.comments)).append("\n");
        sb.append("    aiAnswer: ").append(this.toIndentedString(this.aiAnswer)).append("\n");
        sb.append("    multipleSelectQuestionOptionScores: ").append(this.toIndentedString(this.multipleSelectQuestionOptionScores)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

