/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class BulkJob
implements Serializable {
    private String id = null;
    private StateEnum state = null;
    private ActionEnum action = null;
    private Integer totalCount = null;
    private Integer successfulCount = null;
    private Integer failedCount = null;
    private Date dateStarted = null;
    private Date dateFinished = null;
    private Date dateModified = null;
    private String selfUri = null;

    public BulkJob() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public BulkJob state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The bulk job state.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public BulkJob action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(example="null", value="The bulk job action. This determines what the bulk job does, for example, terminate workitems.")
    @JsonProperty(value="action")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public BulkJob totalCount(Integer totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    @ApiModelProperty(example="null", value="Total count of items to be processed in the bulk job.")
    @JsonProperty(value="totalCount")
    public Integer getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public BulkJob successfulCount(Integer successfulCount) {
        this.successfulCount = successfulCount;
        return this;
    }

    @ApiModelProperty(example="null", value="Count of successfully processed items in the bulk job.")
    @JsonProperty(value="successfulCount")
    public Integer getSuccessfulCount() {
        return this.successfulCount;
    }

    public void setSuccessfulCount(Integer successfulCount) {
        this.successfulCount = successfulCount;
    }

    public BulkJob failedCount(Integer failedCount) {
        this.failedCount = failedCount;
        return this;
    }

    @ApiModelProperty(example="null", value="Count of failed processed items in the bulk job.")
    @JsonProperty(value="failedCount")
    public Integer getFailedCount() {
        return this.failedCount;
    }

    public void setFailedCount(Integer failedCount) {
        this.failedCount = failedCount;
    }

    public BulkJob dateStarted(Date dateStarted) {
        this.dateStarted = dateStarted;
        return this;
    }

    @ApiModelProperty(example="null", value="The bulk job start date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateStarted")
    public Date getDateStarted() {
        return this.dateStarted;
    }

    public void setDateStarted(Date dateStarted) {
        this.dateStarted = dateStarted;
    }

    public BulkJob dateFinished(Date dateFinished) {
        this.dateFinished = dateFinished;
        return this;
    }

    @ApiModelProperty(example="null", value="The bulk job finished date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateFinished")
    public Date getDateFinished() {
        return this.dateFinished;
    }

    public void setDateFinished(Date dateFinished) {
        this.dateFinished = dateFinished;
    }

    public BulkJob dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="The bulk job modification date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkJob bulkJob = (BulkJob)o;
        return Objects.equals(this.id, bulkJob.id) && Objects.equals((Object)this.state, (Object)bulkJob.state) && Objects.equals((Object)this.action, (Object)bulkJob.action) && Objects.equals(this.totalCount, bulkJob.totalCount) && Objects.equals(this.successfulCount, bulkJob.successfulCount) && Objects.equals(this.failedCount, bulkJob.failedCount) && Objects.equals(this.dateStarted, bulkJob.dateStarted) && Objects.equals(this.dateFinished, bulkJob.dateFinished) && Objects.equals(this.dateModified, bulkJob.dateModified) && Objects.equals(this.selfUri, bulkJob.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.action, this.totalCount, this.successfulCount, this.failedCount, this.dateStarted, this.dateFinished, this.dateModified, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkJob {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    totalCount: ").append(this.toIndentedString(this.totalCount)).append("\n");
        sb.append("    successfulCount: ").append(this.toIndentedString(this.successfulCount)).append("\n");
        sb.append("    failedCount: ").append(this.toIndentedString(this.failedCount)).append("\n");
        sb.append("    dateStarted: ").append(this.toIndentedString(this.dateStarted)).append("\n");
        sb.append("    dateFinished: ").append(this.toIndentedString(this.dateFinished)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        IDLE("Idle"),
        QUEUED("Queued"),
        RUNNING("Running"),
        SUCCEEDED("Succeeded"),
        FAILED("Failed"),
        CANCELLED("Cancelled"),
        TERMINATED("Terminated");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ActionEnumDeserializer.class)
    public static enum ActionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TERMINATEWORKITEMS("TerminateWorkitems"),
        ADDWORKITEMS("AddWorkitems");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionEnum value : ActionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActionEnumDeserializer
    extends StdDeserializer<ActionEnum> {
        public ActionEnumDeserializer() {
            super(ActionEnumDeserializer.class);
        }

        public ActionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

