/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.BotVersion;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A bot instance")
public class Bot
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private String provider = null;
    private List<BotVersion> versions = null;
    private String botCompositeTag = null;
    private String selfUri = null;

    public Bot() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.versions = new ArrayList<BotVersion>();
        }
    }

    public Bot id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="This is a string type that should denote a unique ID of the bot for calling purposes by the Genesys service (EG a UUID).")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Bot name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="This is the name that will be displayed to the user in Architect.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Bot description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="An optional description of the bot.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Bot provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", value="The provider of the bot.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public Bot versions(List<BotVersion> versions) {
        this.versions = versions;
        return this;
    }

    @ApiModelProperty(example="null", value="This bots version.")
    @JsonProperty(value="versions")
    public List<BotVersion> getVersions() {
        return this.versions;
    }

    public void setVersions(List<BotVersion> versions) {
        this.versions = versions;
    }

    public Bot botCompositeTag(String botCompositeTag) {
        this.botCompositeTag = botCompositeTag;
        return this;
    }

    @ApiModelProperty(example="null", value="A system-generated string that contains metadata about this bot.")
    @JsonProperty(value="botCompositeTag")
    public String getBotCompositeTag() {
        return this.botCompositeTag;
    }

    public void setBotCompositeTag(String botCompositeTag) {
        this.botCompositeTag = botCompositeTag;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bot bot = (Bot)o;
        return Objects.equals(this.id, bot.id) && Objects.equals(this.name, bot.name) && Objects.equals(this.description, bot.description) && Objects.equals(this.provider, bot.provider) && Objects.equals(this.versions, bot.versions) && Objects.equals(this.botCompositeTag, bot.botCompositeTag) && Objects.equals(this.selfUri, bot.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.provider, this.versions, this.botCompositeTag, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Bot {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    versions: ").append(this.toIndentedString(this.versions)).append("\n");
        sb.append("    botCompositeTag: ").append(this.toIndentedString(this.botCompositeTag)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

