/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AppEventResponseSession;
import com.mypurecloud.sdk.v2.model.CustomEventAttribute;
import com.mypurecloud.sdk.v2.model.Device;
import com.mypurecloud.sdk.v2.model.JourneyApp;
import com.mypurecloud.sdk.v2.model.JourneyCampaign;
import com.mypurecloud.sdk.v2.model.JourneyGeolocation;
import com.mypurecloud.sdk.v2.model.NetworkConnectivity;
import com.mypurecloud.sdk.v2.model.SdkLibrary;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class AppEventResponse
implements Serializable {
    private String id = null;
    private String customerId = null;
    private String customerIdType = null;
    private String eventName = null;
    private String screenName = null;
    private JourneyApp app = null;
    private Device device = null;
    private String ipOrganization = null;
    private JourneyGeolocation geolocation = null;
    private SdkLibrary sdkLibrary = null;
    private NetworkConnectivity networkConnectivity = null;
    private JourneyCampaign mktCampaign = null;
    private AppEventResponseSession session = null;
    private String searchQuery = null;
    private Map<String, CustomEventAttribute> attributes = null;
    private Map<String, CustomEventAttribute> traits = null;
    private Date createdDate = null;

    public AppEventResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public AppEventResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="System-generated UUID for the event.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AppEventResponse customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Identifier of the customer in the source of the event.")
    @JsonProperty(value="customerId")
    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public AppEventResponse customerIdType(String customerIdType) {
        this.customerIdType = customerIdType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of identifier for the customer ID (cookie, email etc.).")
    @JsonProperty(value="customerIdType")
    public String getCustomerIdType() {
        return this.customerIdType;
    }

    public void setCustomerIdType(String customerIdType) {
        this.customerIdType = customerIdType;
    }

    public AppEventResponse eventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Represents the action the customer performed. A good event name is typically an object followed by the action performed in past tense (e.g. screen_viewed, order_completed, user_registered).")
    @JsonProperty(value="eventName")
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public AppEventResponse screenName(String screenName) {
        this.screenName = screenName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the screen in the app that the event took place.")
    @JsonProperty(value="screenName")
    public String getScreenName() {
        return this.screenName;
    }

    public void setScreenName(String screenName) {
        this.screenName = screenName;
    }

    public AppEventResponse app(JourneyApp app) {
        this.app = app;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Application that the customer is interacting with.")
    @JsonProperty(value="app")
    public JourneyApp getApp() {
        return this.app;
    }

    public void setApp(JourneyApp app) {
        this.app = app;
    }

    public AppEventResponse device(Device device) {
        this.device = device;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Customer's device.")
    @JsonProperty(value="device")
    public Device getDevice() {
        return this.device;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public AppEventResponse ipOrganization(String ipOrganization) {
        this.ipOrganization = ipOrganization;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer's IP-based organization or ISP name.")
    @JsonProperty(value="ipOrganization")
    public String getIpOrganization() {
        return this.ipOrganization;
    }

    public void setIpOrganization(String ipOrganization) {
        this.ipOrganization = ipOrganization;
    }

    public AppEventResponse geolocation(JourneyGeolocation geolocation) {
        this.geolocation = geolocation;
        return this;
    }

    @ApiModelProperty(example="null", value="Customer's geolocation.")
    @JsonProperty(value="geolocation")
    public JourneyGeolocation getGeolocation() {
        return this.geolocation;
    }

    public void setGeolocation(JourneyGeolocation geolocation) {
        this.geolocation = geolocation;
    }

    public AppEventResponse sdkLibrary(SdkLibrary sdkLibrary) {
        this.sdkLibrary = sdkLibrary;
        return this;
    }

    @ApiModelProperty(example="null", value="SDK library used to generate the event.")
    @JsonProperty(value="sdkLibrary")
    public SdkLibrary getSdkLibrary() {
        return this.sdkLibrary;
    }

    public void setSdkLibrary(SdkLibrary sdkLibrary) {
        this.sdkLibrary = sdkLibrary;
    }

    public AppEventResponse networkConnectivity(NetworkConnectivity networkConnectivity) {
        this.networkConnectivity = networkConnectivity;
        return this;
    }

    @ApiModelProperty(example="null", value="Information relating to the device's network connectivity.")
    @JsonProperty(value="networkConnectivity")
    public NetworkConnectivity getNetworkConnectivity() {
        return this.networkConnectivity;
    }

    public void setNetworkConnectivity(NetworkConnectivity networkConnectivity) {
        this.networkConnectivity = networkConnectivity;
    }

    public AppEventResponse mktCampaign(JourneyCampaign mktCampaign) {
        this.mktCampaign = mktCampaign;
        return this;
    }

    @ApiModelProperty(example="null", value="Marketing / traffic source information.")
    @JsonProperty(value="mktCampaign")
    public JourneyCampaign getMktCampaign() {
        return this.mktCampaign;
    }

    public void setMktCampaign(JourneyCampaign mktCampaign) {
        this.mktCampaign = mktCampaign;
    }

    public AppEventResponse session(AppEventResponseSession session) {
        this.session = session;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The app session the event belongs to.")
    @JsonProperty(value="session")
    public AppEventResponseSession getSession() {
        return this.session;
    }

    public void setSession(AppEventResponseSession session) {
        this.session = session;
    }

    public AppEventResponse searchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents the keywords in a customer search query.")
    @JsonProperty(value="searchQuery")
    public String getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
    }

    public AppEventResponse attributes(Map<String, CustomEventAttribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="User-defined attributes associated with a particular event.")
    @JsonProperty(value="attributes")
    public Map<String, CustomEventAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, CustomEventAttribute> attributes) {
        this.attributes = attributes;
    }

    public AppEventResponse traits(Map<String, CustomEventAttribute> traits) {
        this.traits = traits;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Traits are attributes intrinsic to the customer that may be sent in selected events (e.g. email, givenName, cellPhone).")
    @JsonProperty(value="traits")
    public Map<String, CustomEventAttribute> getTraits() {
        return this.traits;
    }

    public void setTraits(Map<String, CustomEventAttribute> traits) {
        this.traits = traits;
    }

    public AppEventResponse createdDate(Date createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="UTC timestamp indicating when the event actually took place. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="createdDate")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppEventResponse appEventResponse = (AppEventResponse)o;
        return Objects.equals(this.id, appEventResponse.id) && Objects.equals(this.customerId, appEventResponse.customerId) && Objects.equals(this.customerIdType, appEventResponse.customerIdType) && Objects.equals(this.eventName, appEventResponse.eventName) && Objects.equals(this.screenName, appEventResponse.screenName) && Objects.equals(this.app, appEventResponse.app) && Objects.equals(this.device, appEventResponse.device) && Objects.equals(this.ipOrganization, appEventResponse.ipOrganization) && Objects.equals(this.geolocation, appEventResponse.geolocation) && Objects.equals(this.sdkLibrary, appEventResponse.sdkLibrary) && Objects.equals(this.networkConnectivity, appEventResponse.networkConnectivity) && Objects.equals(this.mktCampaign, appEventResponse.mktCampaign) && Objects.equals(this.session, appEventResponse.session) && Objects.equals(this.searchQuery, appEventResponse.searchQuery) && Objects.equals(this.attributes, appEventResponse.attributes) && Objects.equals(this.traits, appEventResponse.traits) && Objects.equals(this.createdDate, appEventResponse.createdDate);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.customerId, this.customerIdType, this.eventName, this.screenName, this.app, this.device, this.ipOrganization, this.geolocation, this.sdkLibrary, this.networkConnectivity, this.mktCampaign, this.session, this.searchQuery, this.attributes, this.traits, this.createdDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppEventResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    customerIdType: ").append(this.toIndentedString(this.customerIdType)).append("\n");
        sb.append("    eventName: ").append(this.toIndentedString(this.eventName)).append("\n");
        sb.append("    screenName: ").append(this.toIndentedString(this.screenName)).append("\n");
        sb.append("    app: ").append(this.toIndentedString(this.app)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    ipOrganization: ").append(this.toIndentedString(this.ipOrganization)).append("\n");
        sb.append("    geolocation: ").append(this.toIndentedString(this.geolocation)).append("\n");
        sb.append("    sdkLibrary: ").append(this.toIndentedString(this.sdkLibrary)).append("\n");
        sb.append("    networkConnectivity: ").append(this.toIndentedString(this.networkConnectivity)).append("\n");
        sb.append("    mktCampaign: ").append(this.toIndentedString(this.mktCampaign)).append("\n");
        sb.append("    session: ").append(this.toIndentedString(this.session)).append("\n");
        sb.append("    searchQuery: ").append(this.toIndentedString(this.searchQuery)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    traits: ").append(this.toIndentedString(this.traits)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

