/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetGuideVersionJobRequest {
    private String guideId;
    private String versionId;
    private String jobId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGuideId() {
        return this.guideId;
    }

    public void setGuideId(String guideId) {
        this.guideId = guideId;
    }

    public GetGuideVersionJobRequest withGuideId(String guideId) {
        this.setGuideId(guideId);
        return this;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public GetGuideVersionJobRequest withVersionId(String versionId) {
        this.setVersionId(versionId);
        return this;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public GetGuideVersionJobRequest withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetGuideVersionJobRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.guideId == null) {
            throw new IllegalStateException("Missing the required parameter 'guideId' when building request for GetGuideVersionJobRequest.");
        }
        if (this.versionId == null) {
            throw new IllegalStateException("Missing the required parameter 'versionId' when building request for GetGuideVersionJobRequest.");
        }
        if (this.jobId == null) {
            throw new IllegalStateException("Missing the required parameter 'jobId' when building request for GetGuideVersionJobRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/guides/{guideId}/versions/{versionId}/jobs/{jobId}").withPathParameter("guideId", this.guideId).withPathParameter("versionId", this.versionId).withPathParameter("jobId", this.jobId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String guideId, String versionId, String jobId) {
        return new Builder().withRequiredParams(guideId, versionId, jobId);
    }

    public static class Builder {
        private final GetGuideVersionJobRequest request = new GetGuideVersionJobRequest();

        private Builder() {
        }

        public Builder withGuideId(String guideId) {
            this.request.setGuideId(guideId);
            return this;
        }

        public Builder withVersionId(String versionId) {
            this.request.setVersionId(versionId);
            return this;
        }

        public Builder withJobId(String jobId) {
            this.request.setJobId(jobId);
            return this;
        }

        public Builder withRequiredParams(String guideId, String versionId, String jobId) {
            this.request.setGuideId(guideId);
            this.request.setVersionId(versionId);
            this.request.setJobId(jobId);
            return this;
        }

        public GetGuideVersionJobRequest build() {
            if (this.request.guideId == null) {
                throw new IllegalStateException("Missing the required parameter 'guideId' when building request for GetGuideVersionJobRequest.");
            }
            if (this.request.versionId == null) {
                throw new IllegalStateException("Missing the required parameter 'versionId' when building request for GetGuideVersionJobRequest.");
            }
            if (this.request.jobId == null) {
                throw new IllegalStateException("Missing the required parameter 'jobId' when building request for GetGuideVersionJobRequest.");
            }
            return this.request;
        }
    }
}

