/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Request body for fetching the schedule for a group of users over a given time range")
public class UserListScheduleRequestBody
implements Serializable {
    private List<String> userIds = new ArrayList<String>();
    private Date startDate = null;
    private Date endDate = null;

    public UserListScheduleRequestBody userIds(List<String> userIds) {
        this.userIds = userIds;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The user ids for which to fetch schedules")
    @JsonProperty(value="userIds")
    public List<String> getUserIds() {
        return this.userIds;
    }

    public void setUserIds(List<String> userIds) {
        this.userIds = userIds;
    }

    public UserListScheduleRequestBody startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Beginning of the range of schedules to fetch, in ISO-8601 format")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public UserListScheduleRequestBody endDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="End of the range of schedules to fetch, in ISO-8601 format")
    @JsonProperty(value="endDate")
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserListScheduleRequestBody userListScheduleRequestBody = (UserListScheduleRequestBody)o;
        return Objects.equals(this.userIds, userListScheduleRequestBody.userIds) && Objects.equals(this.startDate, userListScheduleRequestBody.startDate) && Objects.equals(this.endDate, userListScheduleRequestBody.endDate);
    }

    public int hashCode() {
        return Objects.hash(this.userIds, this.startDate, this.endDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserListScheduleRequestBody {\n");
        sb.append("    userIds: ").append(this.toIndentedString(this.userIds)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

