/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class PatchTextStyleProperties
implements Serializable {
    private String color = null;
    private String font = null;
    private String fontSize = null;
    private TextAlignEnum textAlign = null;

    public PatchTextStyleProperties() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public PatchTextStyleProperties color(String color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(example="null", value="Color of the text. (eg. #FFFFFF)")
    @JsonProperty(value="color")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public PatchTextStyleProperties font(String font) {
        this.font = font;
        return this;
    }

    @ApiModelProperty(example="null", value="Font of the text. (eg. Helvetica)")
    @JsonProperty(value="font")
    public String getFont() {
        return this.font;
    }

    public void setFont(String font) {
        this.font = font;
    }

    public PatchTextStyleProperties fontSize(String fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    @ApiModelProperty(example="null", value="Font size of the text. (eg. '12')")
    @JsonProperty(value="fontSize")
    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public PatchTextStyleProperties textAlign(TextAlignEnum textAlign) {
        this.textAlign = textAlign;
        return this;
    }

    @ApiModelProperty(example="null", value="Text alignment.")
    @JsonProperty(value="textAlign")
    public TextAlignEnum getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(TextAlignEnum textAlign) {
        this.textAlign = textAlign;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchTextStyleProperties patchTextStyleProperties = (PatchTextStyleProperties)o;
        return Objects.equals(this.color, patchTextStyleProperties.color) && Objects.equals(this.font, patchTextStyleProperties.font) && Objects.equals(this.fontSize, patchTextStyleProperties.fontSize) && Objects.equals((Object)this.textAlign, (Object)patchTextStyleProperties.textAlign);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.color, this.font, this.fontSize, this.textAlign});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PatchTextStyleProperties {\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    font: ").append(this.toIndentedString(this.font)).append("\n");
        sb.append("    fontSize: ").append(this.toIndentedString(this.fontSize)).append("\n");
        sb.append("    textAlign: ").append(this.toIndentedString((Object)this.textAlign)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TextAlignEnumDeserializer.class)
    public static enum TextAlignEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        LEFT("Left"),
        RIGHT("Right"),
        CENTER("Center");

        private String value;

        private TextAlignEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TextAlignEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TextAlignEnum value : TextAlignEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TextAlignEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TextAlignEnumDeserializer
    extends StdDeserializer<TextAlignEnum> {
        public TextAlignEnumDeserializer() {
            super(TextAlignEnumDeserializer.class);
        }

        public TextAlignEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TextAlignEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

