/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.OpenSocialMediaPublicMetadata;
import com.mypurecloud.sdk.v2.model.OpenSocialMediaRecipient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="Channel-specific information that describes the message and the message channel/provider.")
public class OpenSocialMediaChannel
implements Serializable {
    private String id = null;
    private PlatformEnum platform = null;
    private TypeEnum type = null;
    private String messageId = null;
    private OpenSocialMediaRecipient to = null;
    private OpenSocialMediaRecipient from = null;
    private Date time = null;
    private Object metadata = null;
    private OpenSocialMediaPublicMetadata publicMetadata = null;

    public OpenSocialMediaChannel() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The topic ID.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The provider type.")
    @JsonProperty(value="platform")
    public PlatformEnum getPlatform() {
        return this.platform;
    }

    @ApiModelProperty(example="null", value="Specifies if this message is part of a private or public conversation.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public OpenSocialMediaChannel messageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Unique provider ID of the message such as a Facebook message ID.")
    @JsonProperty(value="messageId")
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public OpenSocialMediaChannel to(OpenSocialMediaRecipient to) {
        this.to = to;
        return this;
    }

    @ApiModelProperty(example="null", value="Information about the recipient the message is sent to.")
    @JsonProperty(value="to")
    public OpenSocialMediaRecipient getTo() {
        return this.to;
    }

    public void setTo(OpenSocialMediaRecipient to) {
        this.to = to;
    }

    public OpenSocialMediaChannel from(OpenSocialMediaRecipient from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Information about the recipient the message is received from.")
    @JsonProperty(value="from")
    public OpenSocialMediaRecipient getFrom() {
        return this.from;
    }

    public void setFrom(OpenSocialMediaRecipient from) {
        this.from = from;
    }

    public OpenSocialMediaChannel time(Date time) {
        this.time = time;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Original time of the event. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="time")
    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public OpenSocialMediaChannel metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", value="Information about the channel.")
    @JsonProperty(value="metadata")
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public OpenSocialMediaChannel publicMetadata(OpenSocialMediaPublicMetadata publicMetadata) {
        this.publicMetadata = publicMetadata;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Meta data of this public post. For example, used to define where in the thread the post exists.")
    @JsonProperty(value="publicMetadata")
    public OpenSocialMediaPublicMetadata getPublicMetadata() {
        return this.publicMetadata;
    }

    public void setPublicMetadata(OpenSocialMediaPublicMetadata publicMetadata) {
        this.publicMetadata = publicMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenSocialMediaChannel openSocialMediaChannel = (OpenSocialMediaChannel)o;
        return Objects.equals(this.id, openSocialMediaChannel.id) && Objects.equals((Object)this.platform, (Object)openSocialMediaChannel.platform) && Objects.equals((Object)this.type, (Object)openSocialMediaChannel.type) && Objects.equals(this.messageId, openSocialMediaChannel.messageId) && Objects.equals(this.to, openSocialMediaChannel.to) && Objects.equals(this.from, openSocialMediaChannel.from) && Objects.equals(this.time, openSocialMediaChannel.time) && Objects.equals(this.metadata, openSocialMediaChannel.metadata) && Objects.equals(this.publicMetadata, openSocialMediaChannel.publicMetadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.platform, this.type, this.messageId, this.to, this.from, this.time, this.metadata, this.publicMetadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenSocialMediaChannel {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    platform: ").append(this.toIndentedString((Object)this.platform)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    messageId: ").append(this.toIndentedString(this.messageId)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    publicMetadata: ").append(this.toIndentedString(this.publicMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=PlatformEnumDeserializer.class)
    public static enum PlatformEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OPEN("Open");

        private String value;

        private PlatformEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PlatformEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PlatformEnum value : PlatformEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PlatformEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PUBLIC("Public");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class PlatformEnumDeserializer
    extends StdDeserializer<PlatformEnum> {
        public PlatformEnumDeserializer() {
            super(PlatformEnumDeserializer.class);
        }

        public PlatformEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PlatformEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

