/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.KnowledgeParseImportResult;
import com.mypurecloud.sdk.v2.model.KnowledgeParseRecord;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class KnowledgeParseJobResponse
implements Serializable {
    private String id = null;
    private String downloadURL = null;
    private List<String> hints = null;
    private StatusEnum status = null;
    private List<KnowledgeParseRecord> parseResults = null;
    private KnowledgeParseImportResult importResult = null;
    private UserReference createdBy = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String selfUri = null;

    public KnowledgeParseJobResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.hints = new ArrayList<String>();
            this.parseResults = new ArrayList<KnowledgeParseRecord>();
        }
    }

    @ApiModelProperty(example="null", value="Id of the parse job")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public KnowledgeParseJobResponse downloadURL(String downloadURL) {
        this.downloadURL = downloadURL;
        return this;
    }

    @ApiModelProperty(example="null", value="The URL of the location at which the caller can download the original html file.")
    @JsonProperty(value="downloadURL")
    public String getDownloadURL() {
        return this.downloadURL;
    }

    public void setDownloadURL(String downloadURL) {
        this.downloadURL = downloadURL;
    }

    public KnowledgeParseJobResponse hints(List<String> hints) {
        this.hints = hints;
        return this;
    }

    @ApiModelProperty(example="null", value="Hinted titles for the parser.")
    @JsonProperty(value="hints")
    public List<String> getHints() {
        return this.hints;
    }

    public void setHints(List<String> hints) {
        this.hints = hints;
    }

    @ApiModelProperty(example="null", value="Status of the parse job")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    @ApiModelProperty(example="null", value="Results of the parse")
    @JsonProperty(value="parseResults")
    public List<KnowledgeParseRecord> getParseResults() {
        return this.parseResults;
    }

    @ApiModelProperty(example="null", value="Result of the import phase")
    @JsonProperty(value="importResult")
    public KnowledgeParseImportResult getImportResult() {
        return this.importResult;
    }

    public KnowledgeParseJobResponse createdBy(UserReference createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The user who created the operation")
    @JsonProperty(value="createdBy")
    public UserReference getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UserReference createdBy) {
        this.createdBy = createdBy;
    }

    @ApiModelProperty(example="null", value="Created date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Last modified date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeParseJobResponse knowledgeParseJobResponse = (KnowledgeParseJobResponse)o;
        return Objects.equals(this.id, knowledgeParseJobResponse.id) && Objects.equals(this.downloadURL, knowledgeParseJobResponse.downloadURL) && Objects.equals(this.hints, knowledgeParseJobResponse.hints) && Objects.equals((Object)this.status, (Object)knowledgeParseJobResponse.status) && Objects.equals(this.parseResults, knowledgeParseJobResponse.parseResults) && Objects.equals(this.importResult, knowledgeParseJobResponse.importResult) && Objects.equals(this.createdBy, knowledgeParseJobResponse.createdBy) && Objects.equals(this.dateCreated, knowledgeParseJobResponse.dateCreated) && Objects.equals(this.dateModified, knowledgeParseJobResponse.dateModified) && Objects.equals(this.selfUri, knowledgeParseJobResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.downloadURL, this.hints, this.status, this.parseResults, this.importResult, this.createdBy, this.dateCreated, this.dateModified, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeParseJobResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    downloadURL: ").append(this.toIndentedString(this.downloadURL)).append("\n");
        sb.append("    hints: ").append(this.toIndentedString(this.hints)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    parseResults: ").append(this.toIndentedString(this.parseResults)).append("\n");
        sb.append("    importResult: ").append(this.toIndentedString(this.importResult)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        READYTOPARSE("ReadyToParse"),
        PARSEINPROGRESS("ParseInProgress"),
        PARSECOMPLETED("ParseCompleted"),
        READYTOIMPORT("ReadyToImport"),
        IMPORTINPROGRESS("ImportInProgress"),
        IMPORTCOMPLETED("ImportCompleted"),
        IMPORTPARTIALCOMPLETED("ImportPartialCompleted"),
        IMPORTFAILED("ImportFailed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

