/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DocumentQuery;
import com.mypurecloud.sdk.v2.model.KnowledgeConversationContext;
import com.mypurecloud.sdk.v2.model.KnowledgeSearchClientApplication;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class KnowledgeDocumentChunkRequest
implements Serializable {
    private String query = null;
    private Integer pageSize = null;
    private Integer pageNumber = null;
    private DocumentQuery filter = null;
    private QueryTypeEnum queryType = null;
    private Boolean preprocessQuery = null;
    private Boolean includeDraftDocuments = null;
    private KnowledgeSearchClientApplication application = null;
    private KnowledgeConversationContext conversationContext = null;
    private Float confidenceThreshold = null;

    public KnowledgeDocumentChunkRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public KnowledgeDocumentChunkRequest query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Query to search chunks in the knowledge base.")
    @JsonProperty(value="query")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public KnowledgeDocumentChunkRequest pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", value="Page size of the returned results.")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public KnowledgeDocumentChunkRequest pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Page number of the returned results.")
    @JsonProperty(value="pageNumber")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public KnowledgeDocumentChunkRequest filter(DocumentQuery filter) {
        this.filter = filter;
        return this;
    }

    @ApiModelProperty(example="null", value="Filter for the document chunks.")
    @JsonProperty(value="filter")
    public DocumentQuery getFilter() {
        return this.filter;
    }

    public void setFilter(DocumentQuery filter) {
        this.filter = filter;
    }

    public KnowledgeDocumentChunkRequest queryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of the query that initiates the chunks search.")
    @JsonProperty(value="queryType")
    public QueryTypeEnum getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryTypeEnum queryType) {
        this.queryType = queryType;
    }

    public KnowledgeDocumentChunkRequest preprocessQuery(Boolean preprocessQuery) {
        this.preprocessQuery = preprocessQuery;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether the chunks search query should be preprocessed.")
    @JsonProperty(value="preprocessQuery")
    public Boolean getPreprocessQuery() {
        return this.preprocessQuery;
    }

    public void setPreprocessQuery(Boolean preprocessQuery) {
        this.preprocessQuery = preprocessQuery;
    }

    public KnowledgeDocumentChunkRequest includeDraftDocuments(Boolean includeDraftDocuments) {
        this.includeDraftDocuments = includeDraftDocuments;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether the chunk results would also include draft documents.")
    @JsonProperty(value="includeDraftDocuments")
    public Boolean getIncludeDraftDocuments() {
        return this.includeDraftDocuments;
    }

    public void setIncludeDraftDocuments(Boolean includeDraftDocuments) {
        this.includeDraftDocuments = includeDraftDocuments;
    }

    public KnowledgeDocumentChunkRequest application(KnowledgeSearchClientApplication application) {
        this.application = application;
        return this;
    }

    @ApiModelProperty(example="null", value="The client application details from which chunks request was sent.")
    @JsonProperty(value="application")
    public KnowledgeSearchClientApplication getApplication() {
        return this.application;
    }

    public void setApplication(KnowledgeSearchClientApplication application) {
        this.application = application;
    }

    public KnowledgeDocumentChunkRequest conversationContext(KnowledgeConversationContext conversationContext) {
        this.conversationContext = conversationContext;
        return this;
    }

    @ApiModelProperty(example="null", value="Conversation context information if the chunks search is initiated in the context of a conversation.")
    @JsonProperty(value="conversationContext")
    public KnowledgeConversationContext getConversationContext() {
        return this.conversationContext;
    }

    public void setConversationContext(KnowledgeConversationContext conversationContext) {
        this.conversationContext = conversationContext;
    }

    public KnowledgeDocumentChunkRequest confidenceThreshold(Float confidenceThreshold) {
        this.confidenceThreshold = confidenceThreshold;
        return this;
    }

    @ApiModelProperty(example="null", value="The confidence threshold for the chunk results. If applied, the returned results will have an equal or higher confidence than the threshold. The value should be between 0 to 1.")
    @JsonProperty(value="confidenceThreshold")
    public Float getConfidenceThreshold() {
        return this.confidenceThreshold;
    }

    public void setConfidenceThreshold(Float confidenceThreshold) {
        this.confidenceThreshold = confidenceThreshold;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeDocumentChunkRequest knowledgeDocumentChunkRequest = (KnowledgeDocumentChunkRequest)o;
        return Objects.equals(this.query, knowledgeDocumentChunkRequest.query) && Objects.equals(this.pageSize, knowledgeDocumentChunkRequest.pageSize) && Objects.equals(this.pageNumber, knowledgeDocumentChunkRequest.pageNumber) && Objects.equals(this.filter, knowledgeDocumentChunkRequest.filter) && Objects.equals((Object)this.queryType, (Object)knowledgeDocumentChunkRequest.queryType) && Objects.equals(this.preprocessQuery, knowledgeDocumentChunkRequest.preprocessQuery) && Objects.equals(this.includeDraftDocuments, knowledgeDocumentChunkRequest.includeDraftDocuments) && Objects.equals(this.application, knowledgeDocumentChunkRequest.application) && Objects.equals(this.conversationContext, knowledgeDocumentChunkRequest.conversationContext) && Objects.equals(this.confidenceThreshold, knowledgeDocumentChunkRequest.confidenceThreshold);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.query, this.pageSize, this.pageNumber, this.filter, this.queryType, this.preprocessQuery, this.includeDraftDocuments, this.application, this.conversationContext, this.confidenceThreshold});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeDocumentChunkRequest {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    queryType: ").append(this.toIndentedString((Object)this.queryType)).append("\n");
        sb.append("    preprocessQuery: ").append(this.toIndentedString(this.preprocessQuery)).append("\n");
        sb.append("    includeDraftDocuments: ").append(this.toIndentedString(this.includeDraftDocuments)).append("\n");
        sb.append("    application: ").append(this.toIndentedString(this.application)).append("\n");
        sb.append("    conversationContext: ").append(this.toIndentedString(this.conversationContext)).append("\n");
        sb.append("    confidenceThreshold: ").append(this.toIndentedString(this.confidenceThreshold)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=QueryTypeEnumDeserializer.class)
    public static enum QueryTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AUTOSEARCH("AutoSearch"),
        MANUALSEARCH("ManualSearch"),
        SUGGESTION("Suggestion");

        private String value;

        private QueryTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static QueryTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (QueryTypeEnum value : QueryTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return QueryTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class QueryTypeEnumDeserializer
    extends StdDeserializer<QueryTypeEnum> {
        public QueryTypeEnumDeserializer() {
            super(QueryTypeEnumDeserializer.class);
        }

        public QueryTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return QueryTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

