/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.Function;
import com.mypurecloud.sdk.v2.model.FunctionZipConfig;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Current action function configuration and zip upload configuration.")
public class FunctionConfig
implements Serializable {
    private String id = null;
    private Function function = null;
    private FunctionZipConfig zip = null;
    private List<FunctionZipConfig> uploadExceptionHistory = null;
    private String selfUri = null;

    public FunctionConfig() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.uploadExceptionHistory = new ArrayList<FunctionZipConfig>();
        }
    }

    @ApiModelProperty(example="null", value="Action identifier.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="Function configuration.")
    @JsonProperty(value="function")
    public Function getFunction() {
        return this.function;
    }

    @ApiModelProperty(example="null", value="Zip file configuration and state.")
    @JsonProperty(value="zip")
    public FunctionZipConfig getZip() {
        return this.zip;
    }

    @ApiModelProperty(example="null", value="History of failed zip upload file configuration including their state and error messages. Contains no more than last ten failures.")
    @JsonProperty(value="uploadExceptionHistory")
    public List<FunctionZipConfig> getUploadExceptionHistory() {
        return this.uploadExceptionHistory;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionConfig functionConfig = (FunctionConfig)o;
        return Objects.equals(this.id, functionConfig.id) && Objects.equals(this.function, functionConfig.function) && Objects.equals(this.zip, functionConfig.zip) && Objects.equals(this.uploadExceptionHistory, functionConfig.uploadExceptionHistory) && Objects.equals(this.selfUri, functionConfig.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.function, this.zip, this.uploadExceptionHistory, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FunctionConfig {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    function: ").append(this.toIndentedString(this.function)).append("\n");
        sb.append("    zip: ").append(this.toIndentedString(this.zip)).append("\n");
        sb.append("    uploadExceptionHistory: ").append(this.toIndentedString(this.uploadExceptionHistory)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

