/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class AmazonLexRequest
implements Serializable {
    private Map<String, String> requestAttributes = null;
    private Map<String, String> sessionAttributes = null;

    public AmazonLexRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public AmazonLexRequest requestAttributes(Map<String, String> requestAttributes) {
        this.requestAttributes = requestAttributes;
        return this;
    }

    @ApiModelProperty(example="null", value="AttributeName/AttributeValue pairs of User Defined Request Attributes to be sent to the amazon bot See - https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs")
    @JsonProperty(value="requestAttributes")
    public Map<String, String> getRequestAttributes() {
        return this.requestAttributes;
    }

    public void setRequestAttributes(Map<String, String> requestAttributes) {
        this.requestAttributes = requestAttributes;
    }

    public AmazonLexRequest sessionAttributes(Map<String, String> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
        return this;
    }

    @ApiModelProperty(example="null", value="AttributeName/AttributeValue pairs of Session Attributes to be sent to the amazon bot. See - https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs")
    @JsonProperty(value="sessionAttributes")
    public Map<String, String> getSessionAttributes() {
        return this.sessionAttributes;
    }

    public void setSessionAttributes(Map<String, String> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmazonLexRequest amazonLexRequest = (AmazonLexRequest)o;
        return Objects.equals(this.requestAttributes, amazonLexRequest.requestAttributes) && Objects.equals(this.sessionAttributes, amazonLexRequest.sessionAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.requestAttributes, this.sessionAttributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AmazonLexRequest {\n");
        sb.append("    requestAttributes: ").append(this.toIndentedString(this.requestAttributes)).append("\n");
        sb.append("    sessionAttributes: ").append(this.toIndentedString(this.sessionAttributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

