/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Represents an organization skill assigned to a user. When assigning to a user specify the organization skill id as the id.")
public class UserRoutingSkill
implements Serializable {
    private String id = null;
    private String name = null;
    private Double proficiency = null;
    private StateEnum state = null;
    private String skillUri = null;
    private String selfUri = null;

    public UserRoutingSkill() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public UserRoutingSkill name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UserRoutingSkill proficiency(Double proficiency) {
        this.proficiency = proficiency;
        return this;
    }

    @ApiModelProperty(example="null", value="A rating from 0.0 to 5.0 that indicates how adept an agent is at a particular skill. When \"Best available skills\" is enabled for a queue in Genesys Cloud, ACD interactions in that queue are routed to agents with higher proficiency ratings.")
    @JsonProperty(value="proficiency")
    public Double getProficiency() {
        return this.proficiency;
    }

    public void setProficiency(Double proficiency) {
        this.proficiency = proficiency;
    }

    public UserRoutingSkill state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="Activate or deactivate this routing skill.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    @ApiModelProperty(example="null", value="URI to the organization skill used by this user skill.")
    @JsonProperty(value="skillUri")
    public String getSkillUri() {
        return this.skillUri;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserRoutingSkill userRoutingSkill = (UserRoutingSkill)o;
        return Objects.equals(this.id, userRoutingSkill.id) && Objects.equals(this.name, userRoutingSkill.name) && Objects.equals(this.proficiency, userRoutingSkill.proficiency) && Objects.equals((Object)this.state, (Object)userRoutingSkill.state) && Objects.equals(this.skillUri, userRoutingSkill.skillUri) && Objects.equals(this.selfUri, userRoutingSkill.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.proficiency, this.state, this.skillUri, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserRoutingSkill {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    proficiency: ").append(this.toIndentedString(this.proficiency)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    skillUri: ").append(this.toIndentedString(this.skillUri)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("active"),
        INACTIVE("inactive"),
        DELETED("deleted");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

