/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class TwitterDataIngestionRuleResponse
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private StatusEnum status = null;
    private Integer version = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String platform = null;
    private List<String> countries = null;
    private String searchTerms = null;
    private String selfUri = null;

    public TwitterDataIngestionRuleResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.countries = new ArrayList<String>();
        }
    }

    public TwitterDataIngestionRuleResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the data ingestion rule.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TwitterDataIngestionRuleResponse name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the data ingestion rule.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TwitterDataIngestionRuleResponse description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="A description of the data ingestion rule.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TwitterDataIngestionRuleResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the data ingestion rule.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TwitterDataIngestionRuleResponse version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="The version number of the data ingestion rule.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @ApiModelProperty(example="null", value="Timestamp indicating when the data ingestion rule was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Timestamp indicating when the data ingestion rule was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The platform of the data ingestion rule.")
    @JsonProperty(value="platform")
    public String getPlatform() {
        return this.platform;
    }

    public TwitterDataIngestionRuleResponse countries(List<String> countries) {
        this.countries = countries;
        return this;
    }

    @ApiModelProperty(example="null", value="ISO 3166-1 alpha-2 country codes where Data Ingestion Rules should apply. Defaults to worldwide.")
    @JsonProperty(value="countries")
    public List<String> getCountries() {
        return this.countries;
    }

    public void setCountries(List<String> countries) {
        this.countries = countries;
    }

    public TwitterDataIngestionRuleResponse searchTerms(String searchTerms) {
        this.searchTerms = searchTerms;
        return this;
    }

    @ApiModelProperty(example="null", value="Search terms for X (formally Twitter).")
    @JsonProperty(value="searchTerms")
    public String getSearchTerms() {
        return this.searchTerms;
    }

    public void setSearchTerms(String searchTerms) {
        this.searchTerms = searchTerms;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TwitterDataIngestionRuleResponse twitterDataIngestionRuleResponse = (TwitterDataIngestionRuleResponse)o;
        return Objects.equals(this.id, twitterDataIngestionRuleResponse.id) && Objects.equals(this.name, twitterDataIngestionRuleResponse.name) && Objects.equals(this.description, twitterDataIngestionRuleResponse.description) && Objects.equals((Object)this.status, (Object)twitterDataIngestionRuleResponse.status) && Objects.equals(this.version, twitterDataIngestionRuleResponse.version) && Objects.equals(this.dateCreated, twitterDataIngestionRuleResponse.dateCreated) && Objects.equals(this.dateModified, twitterDataIngestionRuleResponse.dateModified) && Objects.equals(this.platform, twitterDataIngestionRuleResponse.platform) && Objects.equals(this.countries, twitterDataIngestionRuleResponse.countries) && Objects.equals(this.searchTerms, twitterDataIngestionRuleResponse.searchTerms) && Objects.equals(this.selfUri, twitterDataIngestionRuleResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.status, this.version, this.dateCreated, this.dateModified, this.platform, this.countries, this.searchTerms, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TwitterDataIngestionRuleResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    platform: ").append(this.toIndentedString(this.platform)).append("\n");
        sb.append("    countries: ").append(this.toIndentedString(this.countries)).append("\n");
        sb.append("    searchTerms: ").append(this.toIndentedString(this.searchTerms)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("Active"),
        DELETED("Deleted"),
        ERROR("Error"),
        PAUSED("Paused"),
        PENDING("Pending"),
        SYSTEMPAUSED("SystemPaused");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

