/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.Objective;
import com.mypurecloud.sdk.v2.model.PerformanceProfile;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;

public class Metric
implements Serializable {
    private String id = null;
    private String name = null;
    private String metricDefinitionId = null;
    private String externalMetricDefinitionId = null;
    private Objective objective = null;
    private String performanceProfileId = null;
    private AddressableEntityRef linkedMetric = null;
    private Date dateCreated = null;
    private LocalDate dateUnlinked = null;
    private Integer precision = null;
    private TimeDisplayUnitEnum timeDisplayUnit = null;
    private PerformanceProfile sourcePerformanceProfile = null;
    private String selfUri = null;

    public Metric() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Metric name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of this metric")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Metric metricDefinitionId(String metricDefinitionId) {
        this.metricDefinitionId = metricDefinitionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of associated metric definition")
    @JsonProperty(value="metricDefinitionId")
    public String getMetricDefinitionId() {
        return this.metricDefinitionId;
    }

    public void setMetricDefinitionId(String metricDefinitionId) {
        this.metricDefinitionId = metricDefinitionId;
    }

    public Metric externalMetricDefinitionId(String externalMetricDefinitionId) {
        this.externalMetricDefinitionId = externalMetricDefinitionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of associated external metric definition")
    @JsonProperty(value="externalMetricDefinitionId")
    public String getExternalMetricDefinitionId() {
        return this.externalMetricDefinitionId;
    }

    public void setExternalMetricDefinitionId(String externalMetricDefinitionId) {
        this.externalMetricDefinitionId = externalMetricDefinitionId;
    }

    public Metric objective(Objective objective) {
        this.objective = objective;
        return this;
    }

    @ApiModelProperty(example="null", value="Associated objective for this metric")
    @JsonProperty(value="objective")
    public Objective getObjective() {
        return this.objective;
    }

    public void setObjective(Objective objective) {
        this.objective = objective;
    }

    public Metric performanceProfileId(String performanceProfileId) {
        this.performanceProfileId = performanceProfileId;
        return this;
    }

    @ApiModelProperty(example="null", value="Performance profile id of this metric")
    @JsonProperty(value="performanceProfileId")
    public String getPerformanceProfileId() {
        return this.performanceProfileId;
    }

    public void setPerformanceProfileId(String performanceProfileId) {
        this.performanceProfileId = performanceProfileId;
    }

    @ApiModelProperty(example="null", value="The linked metric entity reference")
    @JsonProperty(value="linkedMetric")
    public AddressableEntityRef getLinkedMetric() {
        return this.linkedMetric;
    }

    @ApiModelProperty(example="null", value="The created date of this metric. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The unlinked workday for this metric if this metric was ever unlinked. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="dateUnlinked")
    public LocalDate getDateUnlinked() {
        return this.dateUnlinked;
    }

    @ApiModelProperty(example="null", value="The precision of the metric, must be between 0 and 5")
    @JsonProperty(value="precision")
    public Integer getPrecision() {
        return this.precision;
    }

    public Metric timeDisplayUnit(TimeDisplayUnitEnum timeDisplayUnit) {
        this.timeDisplayUnit = timeDisplayUnit;
        return this;
    }

    @ApiModelProperty(example="null", value="The time unit in which the metric should be displayed -- this parameter is ignored when displaying non-time values")
    @JsonProperty(value="timeDisplayUnit")
    public TimeDisplayUnitEnum getTimeDisplayUnit() {
        return this.timeDisplayUnit;
    }

    public void setTimeDisplayUnit(TimeDisplayUnitEnum timeDisplayUnit) {
        this.timeDisplayUnit = timeDisplayUnit;
    }

    @ApiModelProperty(example="null", value="The source performance profile when this metric is linked")
    @JsonProperty(value="sourcePerformanceProfile")
    public PerformanceProfile getSourcePerformanceProfile() {
        return this.sourcePerformanceProfile;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metric metric = (Metric)o;
        return Objects.equals(this.id, metric.id) && Objects.equals(this.name, metric.name) && Objects.equals(this.metricDefinitionId, metric.metricDefinitionId) && Objects.equals(this.externalMetricDefinitionId, metric.externalMetricDefinitionId) && Objects.equals(this.objective, metric.objective) && Objects.equals(this.performanceProfileId, metric.performanceProfileId) && Objects.equals(this.linkedMetric, metric.linkedMetric) && Objects.equals(this.dateCreated, metric.dateCreated) && Objects.equals(this.dateUnlinked, metric.dateUnlinked) && Objects.equals(this.precision, metric.precision) && Objects.equals((Object)this.timeDisplayUnit, (Object)metric.timeDisplayUnit) && Objects.equals(this.sourcePerformanceProfile, metric.sourcePerformanceProfile) && Objects.equals(this.selfUri, metric.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.metricDefinitionId, this.externalMetricDefinitionId, this.objective, this.performanceProfileId, this.linkedMetric, this.dateCreated, this.dateUnlinked, this.precision, this.timeDisplayUnit, this.sourcePerformanceProfile, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Metric {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    metricDefinitionId: ").append(this.toIndentedString(this.metricDefinitionId)).append("\n");
        sb.append("    externalMetricDefinitionId: ").append(this.toIndentedString(this.externalMetricDefinitionId)).append("\n");
        sb.append("    objective: ").append(this.toIndentedString(this.objective)).append("\n");
        sb.append("    performanceProfileId: ").append(this.toIndentedString(this.performanceProfileId)).append("\n");
        sb.append("    linkedMetric: ").append(this.toIndentedString(this.linkedMetric)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateUnlinked: ").append(this.toIndentedString(this.dateUnlinked)).append("\n");
        sb.append("    precision: ").append(this.toIndentedString(this.precision)).append("\n");
        sb.append("    timeDisplayUnit: ").append(this.toIndentedString((Object)this.timeDisplayUnit)).append("\n");
        sb.append("    sourcePerformanceProfile: ").append(this.toIndentedString(this.sourcePerformanceProfile)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TimeDisplayUnitEnumDeserializer.class)
    public static enum TimeDisplayUnitEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NONE("None"),
        SECONDS("Seconds"),
        MINUTES("Minutes"),
        HOURS("Hours");

        private String value;

        private TimeDisplayUnitEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TimeDisplayUnitEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TimeDisplayUnitEnum value : TimeDisplayUnitEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TimeDisplayUnitEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TimeDisplayUnitEnumDeserializer
    extends StdDeserializer<TimeDisplayUnitEnum> {
        public TimeDisplayUnitEnumDeserializer() {
            super(TimeDisplayUnitEnumDeserializer.class);
        }

        public TimeDisplayUnitEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TimeDisplayUnitEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

