/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.MediaRtpStatistics;
import com.mypurecloud.sdk.v2.model.MediaStatisticsClientInfo;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class MediaStatisticsPostRequest
implements Serializable {
    private SourceTypeEnum sourceType = null;
    private MediaStatisticsClientInfo clientInfo = null;
    private MediaRtpStatistics rtp = null;
    private Integer reconnectAttempts = null;

    public MediaStatisticsPostRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public MediaStatisticsPostRequest sourceType(SourceTypeEnum sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Source type of media endpoint")
    @JsonProperty(value="sourceType")
    public SourceTypeEnum getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SourceTypeEnum sourceType) {
        this.sourceType = sourceType;
    }

    public MediaStatisticsPostRequest clientInfo(MediaStatisticsClientInfo clientInfo) {
        this.clientInfo = clientInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="Client information associated with media endpoint")
    @JsonProperty(value="clientInfo")
    public MediaStatisticsClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public void setClientInfo(MediaStatisticsClientInfo clientInfo) {
        this.clientInfo = clientInfo;
    }

    public MediaStatisticsPostRequest rtp(MediaRtpStatistics rtp) {
        this.rtp = rtp;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Statistics of sent and received RTP. Reference: https://www.rfc-editor.org/rfc/rfc3550")
    @JsonProperty(value="rtp")
    public MediaRtpStatistics getRtp() {
        return this.rtp;
    }

    public void setRtp(MediaRtpStatistics rtp) {
        this.rtp = rtp;
    }

    public MediaStatisticsPostRequest reconnectAttempts(Integer reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
        return this;
    }

    @ApiModelProperty(example="null", value="Media reconnect attempt count")
    @JsonProperty(value="reconnectAttempts")
    public Integer getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public void setReconnectAttempts(Integer reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaStatisticsPostRequest mediaStatisticsPostRequest = (MediaStatisticsPostRequest)o;
        return Objects.equals((Object)this.sourceType, (Object)mediaStatisticsPostRequest.sourceType) && Objects.equals(this.clientInfo, mediaStatisticsPostRequest.clientInfo) && Objects.equals(this.rtp, mediaStatisticsPostRequest.rtp) && Objects.equals(this.reconnectAttempts, mediaStatisticsPostRequest.reconnectAttempts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceType, this.clientInfo, this.rtp, this.reconnectAttempts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MediaStatisticsPostRequest {\n");
        sb.append("    sourceType: ").append(this.toIndentedString((Object)this.sourceType)).append("\n");
        sb.append("    clientInfo: ").append(this.toIndentedString(this.clientInfo)).append("\n");
        sb.append("    rtp: ").append(this.toIndentedString(this.rtp)).append("\n");
        sb.append("    reconnectAttempts: ").append(this.toIndentedString(this.reconnectAttempts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SourceTypeEnumDeserializer.class)
    public static enum SourceTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CLIENT("Client");

        private String value;

        private SourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SourceTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SourceTypeEnum value : SourceTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SourceTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SourceTypeEnumDeserializer
    extends StdDeserializer<SourceTypeEnum> {
        public SourceTypeEnumDeserializer() {
            super(SourceTypeEnumDeserializer.class);
        }

        public SourceTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SourceTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

