/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.LearningShareableContentObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Learning module preview get SCO structure")
public class LearningModulePreviewGetScoStructure
implements Serializable {
    private String id = null;
    private String name = null;
    private SuccessStatusEnum successStatus = null;
    private CompletionStatusEnum completionStatus = null;
    private Float percentageScore = null;
    private LearningShareableContentObject shareableContentObject = null;
    private List<LearningModulePreviewGetScoStructure> children = null;

    public LearningModulePreviewGetScoStructure() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.children = new ArrayList<LearningModulePreviewGetScoStructure>();
        }
    }

    @ApiModelProperty(example="null", value="The id of this SCO in the course manifest")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The name of this SCO in the course manifest")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(example="null", value="The success status of this SCO")
    @JsonProperty(value="successStatus")
    public SuccessStatusEnum getSuccessStatus() {
        return this.successStatus;
    }

    @ApiModelProperty(example="null", value="The completion status of this SCO")
    @JsonProperty(value="completionStatus")
    public CompletionStatusEnum getCompletionStatus() {
        return this.completionStatus;
    }

    @ApiModelProperty(example="null", value="Percentage Score")
    @JsonProperty(value="percentageScore")
    public Float getPercentageScore() {
        return this.percentageScore;
    }

    public LearningModulePreviewGetScoStructure shareableContentObject(LearningShareableContentObject shareableContentObject) {
        this.shareableContentObject = shareableContentObject;
        return this;
    }

    @ApiModelProperty(example="null", value="The SCO (Shareable Content Object) data")
    @JsonProperty(value="shareableContentObject")
    public LearningShareableContentObject getShareableContentObject() {
        return this.shareableContentObject;
    }

    public void setShareableContentObject(LearningShareableContentObject shareableContentObject) {
        this.shareableContentObject = shareableContentObject;
    }

    @ApiModelProperty(example="null", value="Child items belonging to this SCO in the course manifest")
    @JsonProperty(value="children")
    public List<LearningModulePreviewGetScoStructure> getChildren() {
        return this.children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LearningModulePreviewGetScoStructure learningModulePreviewGetScoStructure = (LearningModulePreviewGetScoStructure)o;
        return Objects.equals(this.id, learningModulePreviewGetScoStructure.id) && Objects.equals(this.name, learningModulePreviewGetScoStructure.name) && Objects.equals((Object)this.successStatus, (Object)learningModulePreviewGetScoStructure.successStatus) && Objects.equals((Object)this.completionStatus, (Object)learningModulePreviewGetScoStructure.completionStatus) && Objects.equals(this.percentageScore, learningModulePreviewGetScoStructure.percentageScore) && Objects.equals(this.shareableContentObject, learningModulePreviewGetScoStructure.shareableContentObject) && Objects.equals(this.children, learningModulePreviewGetScoStructure.children);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.successStatus, this.completionStatus, this.percentageScore, this.shareableContentObject, this.children});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LearningModulePreviewGetScoStructure {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    successStatus: ").append(this.toIndentedString((Object)this.successStatus)).append("\n");
        sb.append("    completionStatus: ").append(this.toIndentedString((Object)this.completionStatus)).append("\n");
        sb.append("    percentageScore: ").append(this.toIndentedString(this.percentageScore)).append("\n");
        sb.append("    shareableContentObject: ").append(this.toIndentedString(this.shareableContentObject)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SuccessStatusEnumDeserializer.class)
    public static enum SuccessStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PASSED("Passed"),
        FAILED("Failed"),
        UNKNOWN("Unknown");

        private String value;

        private SuccessStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SuccessStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SuccessStatusEnum value : SuccessStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SuccessStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=CompletionStatusEnumDeserializer.class)
    public static enum CompletionStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        COMPLETED("Completed"),
        INCOMPLETE("Incomplete"),
        NOTATTEMPTED("NotAttempted"),
        UNKNOWN("Unknown");

        private String value;

        private CompletionStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CompletionStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CompletionStatusEnum value : CompletionStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CompletionStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CompletionStatusEnumDeserializer
    extends StdDeserializer<CompletionStatusEnum> {
        public CompletionStatusEnumDeserializer() {
            super(CompletionStatusEnumDeserializer.class);
        }

        public CompletionStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CompletionStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class SuccessStatusEnumDeserializer
    extends StdDeserializer<SuccessStatusEnum> {
        public SuccessStatusEnumDeserializer() {
            super(SuccessStatusEnumDeserializer.class);
        }

        public SuccessStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SuccessStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

