/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DocumentElementLength;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class DocumentBodyImageProperties
implements Serializable {
    private String backgroundColor = null;
    private AlignEnum align = null;
    private Float indentation = null;
    private Float width = null;
    private DocumentElementLength widthWithUnit = null;
    private String altText = null;

    public DocumentBodyImageProperties() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public DocumentBodyImageProperties backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @ApiModelProperty(example="null", value="The background color property for the image. The valid values in hex color code representation. For example black color - #000000")
    @JsonProperty(value="backgroundColor")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public DocumentBodyImageProperties align(AlignEnum align) {
        this.align = align;
        return this;
    }

    @ApiModelProperty(example="null", value="The align property for the image.")
    @JsonProperty(value="align")
    public AlignEnum getAlign() {
        return this.align;
    }

    public void setAlign(AlignEnum align) {
        this.align = align;
    }

    public DocumentBodyImageProperties indentation(Float indentation) {
        this.indentation = indentation;
        return this;
    }

    @ApiModelProperty(example="null", value="The indentation property for the image. The valid values in 'em'.")
    @JsonProperty(value="indentation")
    public Float getIndentation() {
        return this.indentation;
    }

    public void setIndentation(Float indentation) {
        this.indentation = indentation;
    }

    public DocumentBodyImageProperties width(Float width) {
        this.width = width;
        return this;
    }

    @ApiModelProperty(example="null", value="The width of the image converted to em unit.")
    @JsonProperty(value="width")
    public Float getWidth() {
        return this.width;
    }

    public void setWidth(Float width) {
        this.width = width;
    }

    public DocumentBodyImageProperties widthWithUnit(DocumentElementLength widthWithUnit) {
        this.widthWithUnit = widthWithUnit;
        return this;
    }

    @ApiModelProperty(example="null", value="The width of the image in the specified unit.")
    @JsonProperty(value="widthWithUnit")
    public DocumentElementLength getWidthWithUnit() {
        return this.widthWithUnit;
    }

    public void setWidthWithUnit(DocumentElementLength widthWithUnit) {
        this.widthWithUnit = widthWithUnit;
    }

    public DocumentBodyImageProperties altText(String altText) {
        this.altText = altText;
        return this;
    }

    @ApiModelProperty(example="null", value="Alternate text for the image for accessibility and when the image can't be loaded.")
    @JsonProperty(value="altText")
    public String getAltText() {
        return this.altText;
    }

    public void setAltText(String altText) {
        this.altText = altText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentBodyImageProperties documentBodyImageProperties = (DocumentBodyImageProperties)o;
        return Objects.equals(this.backgroundColor, documentBodyImageProperties.backgroundColor) && Objects.equals((Object)this.align, (Object)documentBodyImageProperties.align) && Objects.equals(this.indentation, documentBodyImageProperties.indentation) && Objects.equals(this.width, documentBodyImageProperties.width) && Objects.equals(this.widthWithUnit, documentBodyImageProperties.widthWithUnit) && Objects.equals(this.altText, documentBodyImageProperties.altText);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.backgroundColor, this.align, this.indentation, this.width, this.widthWithUnit, this.altText});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentBodyImageProperties {\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("    align: ").append(this.toIndentedString((Object)this.align)).append("\n");
        sb.append("    indentation: ").append(this.toIndentedString(this.indentation)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("    widthWithUnit: ").append(this.toIndentedString(this.widthWithUnit)).append("\n");
        sb.append("    altText: ").append(this.toIndentedString(this.altText)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AlignEnumDeserializer.class)
    public static enum AlignEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CENTER("Center"),
        LEFT("Left"),
        RIGHT("Right"),
        JUSTIFY("Justify");

        private String value;

        private AlignEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AlignEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AlignEnum value : AlignEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AlignEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AlignEnumDeserializer
    extends StdDeserializer<AlignEnum> {
        public AlignEnumDeserializer() {
            super(AlignEnumDeserializer.class);
        }

        public AlignEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AlignEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

