/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConversationAggregateQueryFilter;
import com.mypurecloud.sdk.v2.model.ConversationAggregationView;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ConversationAsyncAggregationQuery
implements Serializable {
    private String interval = null;
    private String granularity = null;
    private String timeZone = null;
    private List<GroupByEnum> groupBy = null;
    private ConversationAggregateQueryFilter filter = null;
    private List<MetricsEnum> metrics = null;
    private Boolean flattenMultivaluedDimensions = null;
    private List<ConversationAggregationView> views = null;
    private AlternateTimeDimensionEnum alternateTimeDimension = null;
    private Integer pageSize = null;

    public ConversationAsyncAggregationQuery() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.groupBy = new ArrayList<GroupByEnum>();
            this.metrics = new ArrayList<MetricsEnum>();
            this.views = new ArrayList<ConversationAggregationView>();
        }
    }

    public ConversationAsyncAggregationQuery interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Behaves like one clause in a SQL WHERE. Specifies the date and time range of data being queried. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public ConversationAsyncAggregationQuery granularity(String granularity) {
        this.granularity = granularity;
        return this;
    }

    @ApiModelProperty(example="null", value="Granularity aggregates metrics into subpartitions within the time interval specified. The default granularity is the same duration as the interval. Periods are represented as an ISO-8601 string. For example: P1D or P1DT12H")
    @JsonProperty(value="granularity")
    public String getGranularity() {
        return this.granularity;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public ConversationAsyncAggregationQuery timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(example="null", value="Time zone context used to calculate response intervals (this allows resolving DST changes). The interval offset is used even when timeZone is specified. Default is UTC. Time zones are represented as a string of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London")
    @JsonProperty(value="timeZone")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public ConversationAsyncAggregationQuery groupBy(List<GroupByEnum> groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    @ApiModelProperty(example="null", value="Behaves like a SQL GROUPBY. Allows for multiple levels of grouping as a list of dimensions. Partitions resulting aggregate computations into distinct named subgroups rather than across the entire result set as if it were one group.")
    @JsonProperty(value="groupBy")
    public List<GroupByEnum> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<GroupByEnum> groupBy) {
        this.groupBy = groupBy;
    }

    public ConversationAsyncAggregationQuery filter(ConversationAggregateQueryFilter filter) {
        this.filter = filter;
        return this;
    }

    @ApiModelProperty(example="null", value="Behaves like a SQL WHERE clause. This is ANDed with the interval parameter. Expresses boolean logical predicates as well as dimensional filters")
    @JsonProperty(value="filter")
    public ConversationAggregateQueryFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ConversationAggregateQueryFilter filter) {
        this.filter = filter;
    }

    public ConversationAsyncAggregationQuery metrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Behaves like a SQL SELECT clause. Only named metrics will be retrieved.")
    @JsonProperty(value="metrics")
    public List<MetricsEnum> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
    }

    public ConversationAsyncAggregationQuery flattenMultivaluedDimensions(Boolean flattenMultivaluedDimensions) {
        this.flattenMultivaluedDimensions = flattenMultivaluedDimensions;
        return this;
    }

    @ApiModelProperty(example="null", value="Flattens any multivalued dimensions used in response groups (e.g. ['a','b','c']->'a,b,c')")
    @JsonProperty(value="flattenMultivaluedDimensions")
    public Boolean getFlattenMultivaluedDimensions() {
        return this.flattenMultivaluedDimensions;
    }

    public void setFlattenMultivaluedDimensions(Boolean flattenMultivaluedDimensions) {
        this.flattenMultivaluedDimensions = flattenMultivaluedDimensions;
    }

    public ConversationAsyncAggregationQuery views(List<ConversationAggregationView> views) {
        this.views = views;
        return this;
    }

    @ApiModelProperty(example="null", value="Custom derived metric views")
    @JsonProperty(value="views")
    public List<ConversationAggregationView> getViews() {
        return this.views;
    }

    public void setViews(List<ConversationAggregationView> views) {
        this.views = views;
    }

    public ConversationAsyncAggregationQuery alternateTimeDimension(AlternateTimeDimensionEnum alternateTimeDimension) {
        this.alternateTimeDimension = alternateTimeDimension;
        return this;
    }

    @ApiModelProperty(example="null", value="Dimension to use as the alternative timestamp for data in the aggregate.  Choosing \"eventTime\" uses the actual time of the data event.")
    @JsonProperty(value="alternateTimeDimension")
    public AlternateTimeDimensionEnum getAlternateTimeDimension() {
        return this.alternateTimeDimension;
    }

    public void setAlternateTimeDimension(AlternateTimeDimensionEnum alternateTimeDimension) {
        this.alternateTimeDimension = alternateTimeDimension;
    }

    public ConversationAsyncAggregationQuery pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of results per page")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationAsyncAggregationQuery conversationAsyncAggregationQuery = (ConversationAsyncAggregationQuery)o;
        return Objects.equals(this.interval, conversationAsyncAggregationQuery.interval) && Objects.equals(this.granularity, conversationAsyncAggregationQuery.granularity) && Objects.equals(this.timeZone, conversationAsyncAggregationQuery.timeZone) && Objects.equals(this.groupBy, conversationAsyncAggregationQuery.groupBy) && Objects.equals(this.filter, conversationAsyncAggregationQuery.filter) && Objects.equals(this.metrics, conversationAsyncAggregationQuery.metrics) && Objects.equals(this.flattenMultivaluedDimensions, conversationAsyncAggregationQuery.flattenMultivaluedDimensions) && Objects.equals(this.views, conversationAsyncAggregationQuery.views) && Objects.equals((Object)this.alternateTimeDimension, (Object)conversationAsyncAggregationQuery.alternateTimeDimension) && Objects.equals(this.pageSize, conversationAsyncAggregationQuery.pageSize);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.interval, this.granularity, this.timeZone, this.groupBy, this.filter, this.metrics, this.flattenMultivaluedDimensions, this.views, this.alternateTimeDimension, this.pageSize});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationAsyncAggregationQuery {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString(this.granularity)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    flattenMultivaluedDimensions: ").append(this.toIndentedString(this.flattenMultivaluedDimensions)).append("\n");
        sb.append("    views: ").append(this.toIndentedString(this.views)).append("\n");
        sb.append("    alternateTimeDimension: ").append(this.toIndentedString((Object)this.alternateTimeDimension)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AlternateTimeDimensionEnumDeserializer.class)
    public static enum AlternateTimeDimensionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EVENTTIME("eventTime");

        private String value;

        private AlternateTimeDimensionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AlternateTimeDimensionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AlternateTimeDimensionEnum value : AlternateTimeDimensionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AlternateTimeDimensionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AlternateTimeDimensionEnumDeserializer
    extends StdDeserializer<AlternateTimeDimensionEnum> {
        public AlternateTimeDimensionEnumDeserializer() {
            super(AlternateTimeDimensionEnumDeserializer.class);
        }

        public AlternateTimeDimensionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AlternateTimeDimensionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=MetricsEnumDeserializer.class)
    public static enum MetricsEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NBLINDTRANSFERRED("nBlindTransferred"),
        NBOTINTERACTIONS("nBotInteractions"),
        NCOBROWSESESSIONS("nCobrowseSessions"),
        NCONNECTED("nConnected"),
        NCONSULT("nConsult"),
        NCONSULTTRANSFERRED("nConsultTransferred"),
        NERROR("nError"),
        NOFFERED("nOffered"),
        NOUTBOUND("nOutbound"),
        NOUTBOUNDABANDONED("nOutboundAbandoned"),
        NOUTBOUNDATTEMPTED("nOutboundAttempted"),
        NOUTBOUNDCONNECTED("nOutboundConnected"),
        NOVERSLA("nOverSla"),
        NSTATETRANSITIONERROR("nStateTransitionError"),
        NTRANSFERRED("nTransferred"),
        OAUDIOMESSAGECOUNT("oAudioMessageCount"),
        OEXTERNALAUDIOMESSAGECOUNT("oExternalAudioMessageCount"),
        OEXTERNALMEDIACOUNT("oExternalMediaCount"),
        OMEDIACOUNT("oMediaCount"),
        OMESSAGECOUNT("oMessageCount"),
        OMESSAGESEGMENTCOUNT("oMessageSegmentCount"),
        OMESSAGETURN("oMessageTurn"),
        OSERVICELEVEL("oServiceLevel"),
        OSERVICETARGET("oServiceTarget"),
        TABANDON("tAbandon"),
        TACD("tAcd"),
        TACTIVECALLBACK("tActiveCallback"),
        TACTIVECALLBACKCOMPLETE("tActiveCallbackComplete"),
        TACW("tAcw"),
        TAGENTRESPONSETIME("tAgentResponseTime"),
        TALERT("tAlert"),
        TANSWERED("tAnswered"),
        TAVERAGEAGENTRESPONSETIME("tAverageAgentResponseTime"),
        TAVERAGECUSTOMERRESPONSETIME("tAverageCustomerResponseTime"),
        TBARGING("tBarging"),
        TCOACHING("tCoaching"),
        TCOACHINGCOMPLETE("tCoachingComplete"),
        TCONNECTED("tConnected"),
        TCONTACTING("tContacting"),
        TDIALING("tDialing"),
        TFIRSTCONNECT("tFirstConnect"),
        TFIRSTDIAL("tFirstDial"),
        TFIRSTENGAGEMENT("tFirstEngagement"),
        TFIRSTRESPONSE("tFirstResponse"),
        TFLOWOUT("tFlowOut"),
        THANDLE("tHandle"),
        THELD("tHeld"),
        THELDCOMPLETE("tHeldComplete"),
        TIVR("tIvr"),
        TMONITORING("tMonitoring"),
        TMONITORINGCOMPLETE("tMonitoringComplete"),
        TNOTRESPONDING("tNotResponding"),
        TPARK("tPark"),
        TPARKCOMPLETE("tParkComplete"),
        TSHORTABANDON("tShortAbandon"),
        TTALK("tTalk"),
        TTALKCOMPLETE("tTalkComplete"),
        TUSERRESPONSETIME("tUserResponseTime"),
        TVOICEMAIL("tVoicemail"),
        TWAIT("tWait");

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricsEnum value : MetricsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MetricsEnumDeserializer
    extends StdDeserializer<MetricsEnum> {
        public MetricsEnumDeserializer() {
            super(MetricsEnumDeserializer.class);
        }

        public MetricsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MetricsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=GroupByEnumDeserializer.class)
    public static enum GroupByEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVEROUTING("activeRouting"),
        ACTIVESKILLID("activeSkillId"),
        ADDRESSFROM("addressFrom"),
        ADDRESSTO("addressTo"),
        AGENTASSISTANTID("agentAssistantId"),
        AGENTBULLSEYERING("agentBullseyeRing"),
        AGENTOWNED("agentOwned"),
        AGENTRANK("agentRank"),
        AGENTSCORE("agentScore"),
        ANI("ani"),
        ASSIGNERID("assignerId"),
        AUTHENTICATED("authenticated"),
        CONVERSATIONID("conversationId"),
        CONVERSATIONINITIATOR("conversationInitiator"),
        CONVERTEDFROM("convertedFrom"),
        CONVERTEDTO("convertedTo"),
        CUSTOMERPARTICIPATION("customerParticipation"),
        DELIVERYSTATUS("deliveryStatus"),
        DESTINATIONADDRESS("destinationAddress"),
        DIRECTION("direction"),
        DISCONNECTTYPE("disconnectType"),
        DIVISIONID("divisionId"),
        DNIS("dnis"),
        EDGEID("edgeId"),
        ELIGIBLEAGENTCOUNT("eligibleAgentCount"),
        ERRORCODE("errorCode"),
        EXTENDEDDELIVERYSTATUS("extendedDeliveryStatus"),
        EXTERNALCONTACTID("externalContactId"),
        EXTERNALMEDIACOUNT("externalMediaCount"),
        EXTERNALORGANIZATIONID("externalOrganizationId"),
        EXTERNALTAG("externalTag"),
        FIRSTQUEUE("firstQueue"),
        FLAGGEDREASON("flaggedReason"),
        FLOWINTYPE("flowInType"),
        FLOWOUTTYPE("flowOutType"),
        GROUPID("groupId"),
        INTERACTIONTYPE("interactionType"),
        JOURNEYACTIONID("journeyActionId"),
        JOURNEYACTIONMAPID("journeyActionMapId"),
        JOURNEYACTIONMAPVERSION("journeyActionMapVersion"),
        JOURNEYCUSTOMERID("journeyCustomerId"),
        JOURNEYCUSTOMERIDTYPE("journeyCustomerIdType"),
        JOURNEYCUSTOMERSESSIONID("journeyCustomerSessionId"),
        JOURNEYCUSTOMERSESSIONIDTYPE("journeyCustomerSessionIdType"),
        KNOWLEDGEBASEID("knowledgeBaseId"),
        MEDIACOUNT("mediaCount"),
        MEDIATYPE("mediaType"),
        MESSAGETYPE("messageType"),
        ORIGINATINGDIRECTION("originatingDirection"),
        ORIGINATINGSOCIALMEDIAPUBLIC("originatingSocialMediaPublic"),
        OUTBOUNDCAMPAIGNID("outboundCampaignId"),
        OUTBOUNDCONTACTID("outboundContactId"),
        OUTBOUNDCONTACTLISTID("outboundContactListId"),
        PARTICIPANTNAME("participantName"),
        PEERID("peerId"),
        PROPOSEDAGENTID("proposedAgentId"),
        PROVIDER("provider"),
        PURPOSE("purpose"),
        QUEUEID("queueId"),
        REMOTE("remote"),
        REMOVEDSKILLID("removedSkillId"),
        REQUESTEDLANGUAGEID("requestedLanguageId"),
        REQUESTEDROUTING("requestedRouting"),
        REQUESTEDROUTINGSKILLID("requestedRoutingSkillId"),
        ROOMID("roomId"),
        ROUTINGPRIORITY("routingPriority"),
        ROUTINGRING("routingRing"),
        ROUTINGRULE("routingRule"),
        ROUTINGRULETYPE("routingRuleType"),
        SCOREDAGENTID("scoredAgentId"),
        SELECTEDAGENTID("selectedAgentId"),
        SELECTEDAGENTRANK("selectedAgentRank"),
        SELFSERVED("selfServed"),
        SESSIONDNIS("sessionDnis"),
        SESSIONID("sessionId"),
        STATIONID("stationId"),
        TEAMID("teamId"),
        USEDROUTING("usedRouting"),
        USERID("userId"),
        VIDEOPRESENT("videoPresent"),
        WAITINGINTERACTIONCOUNT("waitingInteractionCount"),
        WRAPUPCODE("wrapUpCode");

        private String value;

        private GroupByEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GroupByEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GroupByEnum value : GroupByEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GroupByEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class GroupByEnumDeserializer
    extends StdDeserializer<GroupByEnum> {
        public GroupByEnumDeserializer() {
            super(GroupByEnumDeserializer.class);
        }

        public GroupByEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return GroupByEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

