/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class ConsultTransferEvent
implements Serializable {
    private String eventId = null;
    private Date eventDateTime = null;
    private String conversationId = null;
    private String initiatingCommunicationId = null;
    private String destinationCommunicationId = null;
    private String objectCommunicationId = null;

    public ConsultTransferEvent() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ConsultTransferEvent eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique (V4 UUID) eventId for this event")
    @JsonProperty(value="eventId")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public ConsultTransferEvent eventDateTime(Date eventDateTime) {
        this.eventDateTime = eventDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A Date Time representing the time this event occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="eventDateTime")
    public Date getEventDateTime() {
        return this.eventDateTime;
    }

    public void setEventDateTime(Date eventDateTime) {
        this.eventDateTime = eventDateTime;
    }

    public ConsultTransferEvent conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique Id (V4 UUID) identifying this conversation")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public ConsultTransferEvent initiatingCommunicationId(String initiatingCommunicationId) {
        this.initiatingCommunicationId = initiatingCommunicationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id (V4 UUID) of the communication representing the participant that is initiating the transfer.")
    @JsonProperty(value="initiatingCommunicationId")
    public String getInitiatingCommunicationId() {
        return this.initiatingCommunicationId;
    }

    public void setInitiatingCommunicationId(String initiatingCommunicationId) {
        this.initiatingCommunicationId = initiatingCommunicationId;
    }

    public ConsultTransferEvent destinationCommunicationId(String destinationCommunicationId) {
        this.destinationCommunicationId = destinationCommunicationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id (V4 UUID) of the communication that is being transferred to.")
    @JsonProperty(value="destinationCommunicationId")
    public String getDestinationCommunicationId() {
        return this.destinationCommunicationId;
    }

    public void setDestinationCommunicationId(String destinationCommunicationId) {
        this.destinationCommunicationId = destinationCommunicationId;
    }

    public ConsultTransferEvent objectCommunicationId(String objectCommunicationId) {
        this.objectCommunicationId = objectCommunicationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id (V4 UUID) of the communication that is being transferred.")
    @JsonProperty(value="objectCommunicationId")
    public String getObjectCommunicationId() {
        return this.objectCommunicationId;
    }

    public void setObjectCommunicationId(String objectCommunicationId) {
        this.objectCommunicationId = objectCommunicationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsultTransferEvent consultTransferEvent = (ConsultTransferEvent)o;
        return Objects.equals(this.eventId, consultTransferEvent.eventId) && Objects.equals(this.eventDateTime, consultTransferEvent.eventDateTime) && Objects.equals(this.conversationId, consultTransferEvent.conversationId) && Objects.equals(this.initiatingCommunicationId, consultTransferEvent.initiatingCommunicationId) && Objects.equals(this.destinationCommunicationId, consultTransferEvent.destinationCommunicationId) && Objects.equals(this.objectCommunicationId, consultTransferEvent.objectCommunicationId);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.eventDateTime, this.conversationId, this.initiatingCommunicationId, this.destinationCommunicationId, this.objectCommunicationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConsultTransferEvent {\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventDateTime: ").append(this.toIndentedString(this.eventDateTime)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    initiatingCommunicationId: ").append(this.toIndentedString(this.initiatingCommunicationId)).append("\n");
        sb.append("    destinationCommunicationId: ").append(this.toIndentedString(this.destinationCommunicationId)).append("\n");
        sb.append("    objectCommunicationId: ").append(this.toIndentedString(this.objectCommunicationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

