/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.CampaignOutboundLinesAllocation;
import com.mypurecloud.sdk.v2.model.CampaignOutboundLinesReservation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Lines distribution information or Campaign's Edge Group or Site")
public class CampaignOutboundLinesDistribution
implements Serializable {
    private AddressableEntityRef campaign = null;
    private Integer maxOutboundLineCount = null;
    private BigDecimal maxLineUtilization = null;
    private Integer availableOutboundLines = null;
    private Integer reservedLines = null;
    private List<CampaignOutboundLinesReservation> campaignsWithReservedLines = null;
    private List<CampaignOutboundLinesAllocation> campaignsWithDynamicallyAllocatedLines = null;

    public CampaignOutboundLinesDistribution() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.campaignsWithReservedLines = new ArrayList<CampaignOutboundLinesReservation>();
            this.campaignsWithDynamicallyAllocatedLines = new ArrayList<CampaignOutboundLinesAllocation>();
        }
    }

    public CampaignOutboundLinesDistribution campaign(AddressableEntityRef campaign) {
        this.campaign = campaign;
        return this;
    }

    @ApiModelProperty(example="null", value="The Campaign for which dialing group distribution information was requested")
    @JsonProperty(value="campaign")
    public AddressableEntityRef getCampaign() {
        return this.campaign;
    }

    public void setCampaign(AddressableEntityRef campaign) {
        this.campaign = campaign;
    }

    public CampaignOutboundLinesDistribution maxOutboundLineCount(Integer maxOutboundLineCount) {
        this.maxOutboundLineCount = maxOutboundLineCount;
        return this;
    }

    @ApiModelProperty(example="null", value="Maximum outbound calls that can be placed for Campaign's Edge Group or Site")
    @JsonProperty(value="maxOutboundLineCount")
    public Integer getMaxOutboundLineCount() {
        return this.maxOutboundLineCount;
    }

    public void setMaxOutboundLineCount(Integer maxOutboundLineCount) {
        this.maxOutboundLineCount = maxOutboundLineCount;
    }

    public CampaignOutboundLinesDistribution maxLineUtilization(BigDecimal maxLineUtilization) {
        this.maxLineUtilization = maxLineUtilization;
        return this;
    }

    @ApiModelProperty(example="null", value="Maximum ratio of dialer calls to Campaign's Edge Group or Site capacity")
    @JsonProperty(value="maxLineUtilization")
    public BigDecimal getMaxLineUtilization() {
        return this.maxLineUtilization;
    }

    public void setMaxLineUtilization(BigDecimal maxLineUtilization) {
        this.maxLineUtilization = maxLineUtilization;
    }

    public CampaignOutboundLinesDistribution availableOutboundLines(Integer availableOutboundLines) {
        this.availableOutboundLines = availableOutboundLines;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of available outbound lines in Campaign's Edge Group or Site")
    @JsonProperty(value="availableOutboundLines")
    public Integer getAvailableOutboundLines() {
        return this.availableOutboundLines;
    }

    public void setAvailableOutboundLines(Integer availableOutboundLines) {
        this.availableOutboundLines = availableOutboundLines;
    }

    public CampaignOutboundLinesDistribution reservedLines(Integer reservedLines) {
        this.reservedLines = reservedLines;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of reserved outbound lines in Campaign's Edge Group or Site")
    @JsonProperty(value="reservedLines")
    public Integer getReservedLines() {
        return this.reservedLines;
    }

    public void setReservedLines(Integer reservedLines) {
        this.reservedLines = reservedLines;
    }

    public CampaignOutboundLinesDistribution campaignsWithReservedLines(List<CampaignOutboundLinesReservation> campaignsWithReservedLines) {
        this.campaignsWithReservedLines = campaignsWithReservedLines;
        return this;
    }

    @ApiModelProperty(example="null", value="Information about campaigns with reserving lines in Campaign's Edge Group or Site")
    @JsonProperty(value="campaignsWithReservedLines")
    public List<CampaignOutboundLinesReservation> getCampaignsWithReservedLines() {
        return this.campaignsWithReservedLines;
    }

    public void setCampaignsWithReservedLines(List<CampaignOutboundLinesReservation> campaignsWithReservedLines) {
        this.campaignsWithReservedLines = campaignsWithReservedLines;
    }

    public CampaignOutboundLinesDistribution campaignsWithDynamicallyAllocatedLines(List<CampaignOutboundLinesAllocation> campaignsWithDynamicallyAllocatedLines) {
        this.campaignsWithDynamicallyAllocatedLines = campaignsWithDynamicallyAllocatedLines;
        return this;
    }

    @ApiModelProperty(example="null", value="Information about campaigns using dynamic lines allocation in Campaign's Edge Group or Site")
    @JsonProperty(value="campaignsWithDynamicallyAllocatedLines")
    public List<CampaignOutboundLinesAllocation> getCampaignsWithDynamicallyAllocatedLines() {
        return this.campaignsWithDynamicallyAllocatedLines;
    }

    public void setCampaignsWithDynamicallyAllocatedLines(List<CampaignOutboundLinesAllocation> campaignsWithDynamicallyAllocatedLines) {
        this.campaignsWithDynamicallyAllocatedLines = campaignsWithDynamicallyAllocatedLines;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CampaignOutboundLinesDistribution campaignOutboundLinesDistribution = (CampaignOutboundLinesDistribution)o;
        return Objects.equals(this.campaign, campaignOutboundLinesDistribution.campaign) && Objects.equals(this.maxOutboundLineCount, campaignOutboundLinesDistribution.maxOutboundLineCount) && Objects.equals(this.maxLineUtilization, campaignOutboundLinesDistribution.maxLineUtilization) && Objects.equals(this.availableOutboundLines, campaignOutboundLinesDistribution.availableOutboundLines) && Objects.equals(this.reservedLines, campaignOutboundLinesDistribution.reservedLines) && Objects.equals(this.campaignsWithReservedLines, campaignOutboundLinesDistribution.campaignsWithReservedLines) && Objects.equals(this.campaignsWithDynamicallyAllocatedLines, campaignOutboundLinesDistribution.campaignsWithDynamicallyAllocatedLines);
    }

    public int hashCode() {
        return Objects.hash(this.campaign, this.maxOutboundLineCount, this.maxLineUtilization, this.availableOutboundLines, this.reservedLines, this.campaignsWithReservedLines, this.campaignsWithDynamicallyAllocatedLines);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CampaignOutboundLinesDistribution {\n");
        sb.append("    campaign: ").append(this.toIndentedString(this.campaign)).append("\n");
        sb.append("    maxOutboundLineCount: ").append(this.toIndentedString(this.maxOutboundLineCount)).append("\n");
        sb.append("    maxLineUtilization: ").append(this.toIndentedString(this.maxLineUtilization)).append("\n");
        sb.append("    availableOutboundLines: ").append(this.toIndentedString(this.availableOutboundLines)).append("\n");
        sb.append("    reservedLines: ").append(this.toIndentedString(this.reservedLines)).append("\n");
        sb.append("    campaignsWithReservedLines: ").append(this.toIndentedString(this.campaignsWithReservedLines)).append("\n");
        sb.append("    campaignsWithDynamicallyAllocatedLines: ").append(this.toIndentedString(this.campaignsWithDynamicallyAllocatedLines)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

