/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class UserState
implements Serializable {
    private StateEnum state = null;
    private Integer version = null;
    private StateChangeReasonEnum stateChangeReason = null;
    private Date stateChangeDate = null;

    public UserState() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public UserState state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="User's current state.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public UserState version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="Version of this user.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public UserState stateChangeReason(StateChangeReasonEnum stateChangeReason) {
        this.stateChangeReason = stateChangeReason;
        return this;
    }

    @ApiModelProperty(example="null", value="Reason for a change in the user's state.")
    @JsonProperty(value="stateChangeReason")
    public StateChangeReasonEnum getStateChangeReason() {
        return this.stateChangeReason;
    }

    public void setStateChangeReason(StateChangeReasonEnum stateChangeReason) {
        this.stateChangeReason = stateChangeReason;
    }

    @ApiModelProperty(example="null", value="Date that the state was last changed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="stateChangeDate")
    public Date getStateChangeDate() {
        return this.stateChangeDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserState userState = (UserState)o;
        return Objects.equals((Object)this.state, (Object)userState.state) && Objects.equals(this.version, userState.version) && Objects.equals((Object)this.stateChangeReason, (Object)userState.stateChangeReason) && Objects.equals(this.stateChangeDate, userState.stateChangeDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.version, this.stateChangeReason, this.stateChangeDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserState {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    stateChangeReason: ").append(this.toIndentedString((Object)this.stateChangeReason)).append("\n");
        sb.append("    stateChangeDate: ").append(this.toIndentedString(this.stateChangeDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("active"),
        INACTIVE("inactive"),
        DELETED("deleted");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StateChangeReasonEnumDeserializer.class)
    public static enum StateChangeReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        VOLUNTARY("Voluntary"),
        SEASONAL("Seasonal"),
        LEAVE("Leave"),
        PERFORMANCE("Performance"),
        CONDUCT("Conduct"),
        UNKNOWN("Unknown");

        private String value;

        private StateChangeReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateChangeReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateChangeReasonEnum value : StateChangeReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateChangeReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateChangeReasonEnumDeserializer
    extends StdDeserializer<StateChangeReasonEnum> {
        public StateChangeReasonEnumDeserializer() {
            super(StateChangeReasonEnumDeserializer.class);
        }

        public StateChangeReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateChangeReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

