/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.JourneyViewChartDisplayAttributes;
import com.mypurecloud.sdk.v2.model.JourneyViewChartGroupByAttribute;
import com.mypurecloud.sdk.v2.model.JourneyViewChartMetric;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A chart within the context of the elements of the the journey view")
public class JourneyViewChart
implements Serializable {
    private String id = null;
    private String name = null;
    private Integer version = null;
    private GroupByTimeEnum groupByTime = null;
    private List<JourneyViewChartGroupByAttribute> groupByAttributes = null;
    private List<JourneyViewChartMetric> metrics = null;
    private JourneyViewChartDisplayAttributes displayAttributes = null;
    private Integer groupByMax = null;
    private String selfUri = null;

    public JourneyViewChart() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.groupByAttributes = new ArrayList<JourneyViewChartGroupByAttribute>();
            this.metrics = new ArrayList<JourneyViewChartMetric>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public JourneyViewChart name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="The version of the journey view chart")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public JourneyViewChart groupByTime(GroupByTimeEnum groupByTime) {
        this.groupByTime = groupByTime;
        return this;
    }

    @ApiModelProperty(example="null", value="A time unit to group the metrics by. There is a limit on the number of groupBy properties which can be specified.")
    @JsonProperty(value="groupByTime")
    public GroupByTimeEnum getGroupByTime() {
        return this.groupByTime;
    }

    public void setGroupByTime(GroupByTimeEnum groupByTime) {
        this.groupByTime = groupByTime;
    }

    public JourneyViewChart groupByAttributes(List<JourneyViewChartGroupByAttribute> groupByAttributes) {
        this.groupByAttributes = groupByAttributes;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of attributes to group the metrics by. There is a limit on the number of groupBy properties which can be specified.")
    @JsonProperty(value="groupByAttributes")
    public List<JourneyViewChartGroupByAttribute> getGroupByAttributes() {
        return this.groupByAttributes;
    }

    public void setGroupByAttributes(List<JourneyViewChartGroupByAttribute> groupByAttributes) {
        this.groupByAttributes = groupByAttributes;
    }

    public JourneyViewChart metrics(List<JourneyViewChartMetric> metrics) {
        this.metrics = metrics;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A list of metrics to calculate within the chart by (aka the y axis)")
    @JsonProperty(value="metrics")
    public List<JourneyViewChartMetric> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<JourneyViewChartMetric> metrics) {
        this.metrics = metrics;
    }

    public JourneyViewChart displayAttributes(JourneyViewChartDisplayAttributes displayAttributes) {
        this.displayAttributes = displayAttributes;
        return this;
    }

    @ApiModelProperty(example="null", value="Optional display attributes for rendering the chart")
    @JsonProperty(value="displayAttributes")
    public JourneyViewChartDisplayAttributes getDisplayAttributes() {
        return this.displayAttributes;
    }

    public void setDisplayAttributes(JourneyViewChartDisplayAttributes displayAttributes) {
        this.displayAttributes = displayAttributes;
    }

    public JourneyViewChart groupByMax(Integer groupByMax) {
        this.groupByMax = groupByMax;
        return this;
    }

    @ApiModelProperty(example="null", value="A maximum on the number of values being grouped by")
    @JsonProperty(value="groupByMax")
    public Integer getGroupByMax() {
        return this.groupByMax;
    }

    public void setGroupByMax(Integer groupByMax) {
        this.groupByMax = groupByMax;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JourneyViewChart journeyViewChart = (JourneyViewChart)o;
        return Objects.equals(this.id, journeyViewChart.id) && Objects.equals(this.name, journeyViewChart.name) && Objects.equals(this.version, journeyViewChart.version) && Objects.equals((Object)this.groupByTime, (Object)journeyViewChart.groupByTime) && Objects.equals(this.groupByAttributes, journeyViewChart.groupByAttributes) && Objects.equals(this.metrics, journeyViewChart.metrics) && Objects.equals(this.displayAttributes, journeyViewChart.displayAttributes) && Objects.equals(this.groupByMax, journeyViewChart.groupByMax) && Objects.equals(this.selfUri, journeyViewChart.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.version, this.groupByTime, this.groupByAttributes, this.metrics, this.displayAttributes, this.groupByMax, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JourneyViewChart {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    groupByTime: ").append(this.toIndentedString((Object)this.groupByTime)).append("\n");
        sb.append("    groupByAttributes: ").append(this.toIndentedString(this.groupByAttributes)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    displayAttributes: ").append(this.toIndentedString(this.displayAttributes)).append("\n");
        sb.append("    groupByMax: ").append(this.toIndentedString(this.groupByMax)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=GroupByTimeEnumDeserializer.class)
    public static enum GroupByTimeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DAY("Day"),
        WEEK("Week"),
        MONTH("Month"),
        YEAR("Year");

        private String value;

        private GroupByTimeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GroupByTimeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GroupByTimeEnum value : GroupByTimeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GroupByTimeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class GroupByTimeEnumDeserializer
    extends StdDeserializer<GroupByTimeEnum> {
        public GroupByTimeEnumDeserializer() {
            super(GroupByTimeEnumDeserializer.class);
        }

        public GroupByTimeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return GroupByTimeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

