/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class EnrichFieldRule
implements Serializable {
    private String field = null;
    private ActionEnum action = null;
    private ArrayActionEnum arrayAction = null;

    public EnrichFieldRule() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public EnrichFieldRule field(String field) {
        this.field = field;
        return this;
    }

    @ApiModelProperty(example="null", value="A restricted JSONPath naming the specific field this combining behavior should apply to. You may use dot-notation for named fields, and array indexing for lists, but nothing more sophisticated (e.g. wildcards, sublists, filter expressions, etc). For example, to target the `firstName` field of a Contact, this should be \"$.firstName\".")
    @JsonProperty(value="field")
    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public EnrichFieldRule action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(example="null", value="The behavior for how to combine data from the request body and the database.")
    @JsonProperty(value="action")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public EnrichFieldRule arrayAction(ArrayActionEnum arrayAction) {
        this.arrayAction = arrayAction;
        return this;
    }

    @ApiModelProperty(example="null", value="The behavior for how to combine items in array field from the request body and the database.")
    @JsonProperty(value="arrayAction")
    public ArrayActionEnum getArrayAction() {
        return this.arrayAction;
    }

    public void setArrayAction(ArrayActionEnum arrayAction) {
        this.arrayAction = arrayAction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnrichFieldRule enrichFieldRule = (EnrichFieldRule)o;
        return Objects.equals(this.field, enrichFieldRule.field) && Objects.equals((Object)this.action, (Object)enrichFieldRule.action) && Objects.equals((Object)this.arrayAction, (Object)enrichFieldRule.arrayAction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.action, this.arrayAction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnrichFieldRule {\n");
        sb.append("    field: ").append(this.toIndentedString(this.field)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    arrayAction: ").append(this.toIndentedString((Object)this.arrayAction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActionEnumDeserializer.class)
    public static enum ActionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALWAYSUSEPROVIDED("AlwaysUseProvided"),
        PREFEREXISTING("PreferExisting"),
        PREFERPROVIDED("PreferProvided");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionEnum value : ActionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ArrayActionEnumDeserializer.class)
    public static enum ArrayActionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        REPLACE("Replace"),
        EXTEND("Extend"),
        FILL("Fill");

        private String value;

        private ArrayActionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ArrayActionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ArrayActionEnum value : ArrayActionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ArrayActionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ArrayActionEnumDeserializer
    extends StdDeserializer<ArrayActionEnum> {
        public ArrayActionEnumDeserializer() {
            super(ArrayActionEnumDeserializer.class);
        }

        public ArrayActionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ArrayActionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ActionEnumDeserializer
    extends StdDeserializer<ActionEnum> {
        public ActionEnumDeserializer() {
            super(ActionEnumDeserializer.class);
        }

        public ActionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

