/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.DashboardsSharedWith;
import com.mypurecloud.sdk.v2.model.Widget;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class DashboardConfiguration
implements Serializable {
    private String id = null;
    private String name = null;
    private Integer rows = null;
    private Integer columns = null;
    private List<Widget> widgets = null;
    private Boolean favorite = null;
    private Boolean publicDashboard = null;
    private Boolean restricted = null;
    private LayoutTypeEnum layoutType = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Date dateDeleted = null;
    private AddressableEntityRef createdBy = null;
    private Boolean shared = null;
    private DashboardsSharedWith dashboardsSharedWith = null;
    private String selfUri = null;

    public DashboardConfiguration() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.widgets = new ArrayList<Widget>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public DashboardConfiguration name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of dashboard configuration.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DashboardConfiguration rows(Integer rows) {
        this.rows = rows;
        return this;
    }

    @ApiModelProperty(example="null", value="The count of rows for the specific dashboard configuration.")
    @JsonProperty(value="rows")
    public Integer getRows() {
        return this.rows;
    }

    public void setRows(Integer rows) {
        this.rows = rows;
    }

    public DashboardConfiguration columns(Integer columns) {
        this.columns = columns;
        return this;
    }

    @ApiModelProperty(example="null", value="The count of columns for the specific dashboard.")
    @JsonProperty(value="columns")
    public Integer getColumns() {
        return this.columns;
    }

    public void setColumns(Integer columns) {
        this.columns = columns;
    }

    public DashboardConfiguration widgets(List<Widget> widgets) {
        this.widgets = widgets;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="List of widgets for dashboard configuration.")
    @JsonProperty(value="widgets")
    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public void setWidgets(List<Widget> widgets) {
        this.widgets = widgets;
    }

    public DashboardConfiguration favorite(Boolean favorite) {
        this.favorite = favorite;
        return this;
    }

    @ApiModelProperty(example="null", value="The flag indicates if the dashboard is favorited by the user")
    @JsonProperty(value="favorite")
    public Boolean getFavorite() {
        return this.favorite;
    }

    public void setFavorite(Boolean favorite) {
        this.favorite = favorite;
    }

    public DashboardConfiguration publicDashboard(Boolean publicDashboard) {
        this.publicDashboard = publicDashboard;
        return this;
    }

    @ApiModelProperty(example="null", value="The flag to indicate if the dashboard is published by an user")
    @JsonProperty(value="publicDashboard")
    public Boolean getPublicDashboard() {
        return this.publicDashboard;
    }

    public void setPublicDashboard(Boolean publicDashboard) {
        this.publicDashboard = publicDashboard;
    }

    @ApiModelProperty(example="null", value="The flag to indicate if the dashboard has any restricted data for that user")
    @JsonProperty(value="restricted")
    public Boolean getRestricted() {
        return this.restricted;
    }

    public DashboardConfiguration layoutType(LayoutTypeEnum layoutType) {
        this.layoutType = layoutType;
        return this;
    }

    @ApiModelProperty(example="null", value="The layout type of the dashboard")
    @JsonProperty(value="layoutType")
    public LayoutTypeEnum getLayoutType() {
        return this.layoutType;
    }

    public void setLayoutType(LayoutTypeEnum layoutType) {
        this.layoutType = layoutType;
    }

    public DashboardConfiguration dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The created date of the dashboard. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public DashboardConfiguration dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The last modified date of the dashboard. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public DashboardConfiguration dateDeleted(Date dateDeleted) {
        this.dateDeleted = dateDeleted;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The deleted date of the dashboard. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateDeleted")
    public Date getDateDeleted() {
        return this.dateDeleted;
    }

    public void setDateDeleted(Date dateDeleted) {
        this.dateDeleted = dateDeleted;
    }

    @ApiModelProperty(example="null", value="The id of user who created the dashboard")
    @JsonProperty(value="createdBy")
    public AddressableEntityRef getCreatedBy() {
        return this.createdBy;
    }

    public DashboardConfiguration shared(Boolean shared) {
        this.shared = shared;
        return this;
    }

    @ApiModelProperty(example="null", value="The flag to indicate if the dashboard is shared")
    @JsonProperty(value="shared")
    public Boolean getShared() {
        return this.shared;
    }

    public void setShared(Boolean shared) {
        this.shared = shared;
    }

    public DashboardConfiguration dashboardsSharedWith(DashboardsSharedWith dashboardsSharedWith) {
        this.dashboardsSharedWith = dashboardsSharedWith;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of users and teams the dashboard is shared with")
    @JsonProperty(value="dashboardsSharedWith")
    public DashboardsSharedWith getDashboardsSharedWith() {
        return this.dashboardsSharedWith;
    }

    public void setDashboardsSharedWith(DashboardsSharedWith dashboardsSharedWith) {
        this.dashboardsSharedWith = dashboardsSharedWith;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardConfiguration dashboardConfiguration = (DashboardConfiguration)o;
        return Objects.equals(this.id, dashboardConfiguration.id) && Objects.equals(this.name, dashboardConfiguration.name) && Objects.equals(this.rows, dashboardConfiguration.rows) && Objects.equals(this.columns, dashboardConfiguration.columns) && Objects.equals(this.widgets, dashboardConfiguration.widgets) && Objects.equals(this.favorite, dashboardConfiguration.favorite) && Objects.equals(this.publicDashboard, dashboardConfiguration.publicDashboard) && Objects.equals(this.restricted, dashboardConfiguration.restricted) && Objects.equals((Object)this.layoutType, (Object)dashboardConfiguration.layoutType) && Objects.equals(this.dateCreated, dashboardConfiguration.dateCreated) && Objects.equals(this.dateModified, dashboardConfiguration.dateModified) && Objects.equals(this.dateDeleted, dashboardConfiguration.dateDeleted) && Objects.equals(this.createdBy, dashboardConfiguration.createdBy) && Objects.equals(this.shared, dashboardConfiguration.shared) && Objects.equals(this.dashboardsSharedWith, dashboardConfiguration.dashboardsSharedWith) && Objects.equals(this.selfUri, dashboardConfiguration.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.rows, this.columns, this.widgets, this.favorite, this.publicDashboard, this.restricted, this.layoutType, this.dateCreated, this.dateModified, this.dateDeleted, this.createdBy, this.shared, this.dashboardsSharedWith, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DashboardConfiguration {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    rows: ").append(this.toIndentedString(this.rows)).append("\n");
        sb.append("    columns: ").append(this.toIndentedString(this.columns)).append("\n");
        sb.append("    widgets: ").append(this.toIndentedString(this.widgets)).append("\n");
        sb.append("    favorite: ").append(this.toIndentedString(this.favorite)).append("\n");
        sb.append("    publicDashboard: ").append(this.toIndentedString(this.publicDashboard)).append("\n");
        sb.append("    restricted: ").append(this.toIndentedString(this.restricted)).append("\n");
        sb.append("    layoutType: ").append(this.toIndentedString((Object)this.layoutType)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    dateDeleted: ").append(this.toIndentedString(this.dateDeleted)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    shared: ").append(this.toIndentedString(this.shared)).append("\n");
        sb.append("    dashboardsSharedWith: ").append(this.toIndentedString(this.dashboardsSharedWith)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=LayoutTypeEnumDeserializer.class)
    public static enum LayoutTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GRID("Grid"),
        FLOW("Flow");

        private String value;

        private LayoutTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LayoutTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LayoutTypeEnum value : LayoutTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LayoutTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class LayoutTypeEnumDeserializer
    extends StdDeserializer<LayoutTypeEnum> {
        public LayoutTypeEnumDeserializer() {
            super(LayoutTypeEnumDeserializer.class);
        }

        public LayoutTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return LayoutTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

