/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="A singular criteria used to query executionData.")
public class CriteriaItem
implements Serializable {
    private KeyEnum key = null;
    private OperatorEnum operator = null;
    private String value = null;

    public CriteriaItem() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public CriteriaItem key(KeyEnum key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the criteria to be checked.")
    @JsonProperty(value="key")
    public KeyEnum getKey() {
        return this.key;
    }

    public void setKey(KeyEnum key) {
        this.key = key;
    }

    public CriteriaItem operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(example="null", value="The operator used to check on the criteria id.")
    @JsonProperty(value="operator")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public CriteriaItem value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="The target value used to query on.")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CriteriaItem criteriaItem = (CriteriaItem)o;
        return Objects.equals((Object)this.key, (Object)criteriaItem.key) && Objects.equals((Object)this.operator, (Object)criteriaItem.operator) && Objects.equals(this.value, criteriaItem.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.operator, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CriteriaItem {\n");
        sb.append("    key: ").append(this.toIndentedString((Object)this.key)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=KeyEnumDeserializer.class)
    public static enum KeyEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        FLOWSTARTDATETIME("FlowStartDateTime"),
        FLOWENDDATETIME("FlowEndDateTime"),
        CONVERSATIONID("ConversationId"),
        WORKITEMID("WorkitemId"),
        FLOWTYPE("FlowType"),
        FLOWID("FlowId"),
        FLOWERRORREASON("FlowErrorReason"),
        FLOWWARNINGREASON("FlowWarningReason"),
        FLOWALTERNATEEXECUTIONID("FlowAlternateExecutionId"),
        FLOWOBJECTEXECUTIONID("FlowObjectExecutionId"),
        FLOWACTIONID("FlowActionId"),
        FLOWACTIONTYPE("FlowActionType"),
        FLOWACTIONOUTPUTPATHID("FlowActionOutputPathId"),
        FLOWACTIONOUTPUTPATHNAME("FlowActionOutputPathName"),
        FLOWACTIONIDOUTPUTPATHID("FlowActionIdOutputPathId"),
        FLOWACTIONIDOUTPUTPATHNAME("FlowActionIdOutputPathName"),
        FLOWACTIONTYPEOUTPUTPATHID("FlowActionTypeOutputPathId"),
        FLOWACTIONTYPEOUTPUTPATHNAME("FlowActionTypeOutputPathName"),
        BOTID("BotId"),
        BOTERRORREASON("BotErrorReason"),
        BOTFLOWEXECUTIONID("BotFlowExecutionId"),
        BOTOBJECTEXECUTIONID("BotObjectExecutionId");

        private String value;

        private KeyEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static KeyEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (KeyEnum value : KeyEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return KeyEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=OperatorEnumDeserializer.class)
    public static enum OperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EQ("eq"),
        GT("gt"),
        GTE("gte"),
        LT("lt"),
        LTE("lte"),
        NOT("not"),
        BEGINS("begins"),
        NOT_NULL("not_null");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperatorEnum value : OperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OperatorEnumDeserializer
    extends StdDeserializer<OperatorEnum> {
        public OperatorEnumDeserializer() {
            super(OperatorEnumDeserializer.class);
        }

        public OperatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OperatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class KeyEnumDeserializer
    extends StdDeserializer<KeyEnum> {
        public KeyEnumDeserializer() {
            super(KeyEnumDeserializer.class);
        }

        public KeyEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return KeyEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

