/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Metadata information about a message content.")
public class ConversationMessageMetadataContent
implements Serializable {
    private ContentTypeEnum contentType = null;
    private SubTypeEnum subType = null;

    public ConversationMessageMetadataContent() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ConversationMessageMetadataContent contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of this content element.")
    @JsonProperty(value="contentType")
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public ConversationMessageMetadataContent subType(SubTypeEnum subType) {
        this.subType = subType;
        return this;
    }

    @ApiModelProperty(example="null", value="Content subtype")
    @JsonProperty(value="subType")
    public SubTypeEnum getSubType() {
        return this.subType;
    }

    public void setSubType(SubTypeEnum subType) {
        this.subType = subType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationMessageMetadataContent conversationMessageMetadataContent = (ConversationMessageMetadataContent)o;
        return Objects.equals((Object)this.contentType, (Object)conversationMessageMetadataContent.contentType) && Objects.equals((Object)this.subType, (Object)conversationMessageMetadataContent.subType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contentType, this.subType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationMessageMetadataContent {\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    subType: ").append(this.toIndentedString((Object)this.subType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ContentTypeEnumDeserializer.class)
    public static enum ContentTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        REACTIONS("Reactions"),
        ATTACHMENT("Attachment"),
        LOCATION("Location"),
        QUICKREPLY("QuickReply"),
        NOTIFICATION("Notification"),
        BUTTONRESPONSE("ButtonResponse"),
        STORY("Story"),
        MENTION("Mention"),
        CARD("Card"),
        CAROUSEL("Carousel"),
        TEXT("Text"),
        QUICKREPLYV2("QuickReplyV2"),
        DATEPICKER("DatePicker"),
        INTERACTIVEAPPLICATION("InteractiveApplication"),
        LISTPICKER("ListPicker"),
        PAYMENTREQUEST("PaymentRequest"),
        PAYMENTRESPONSE("PaymentResponse"),
        PUSH("Push"),
        FORM("Form"),
        UNKNOWN("Unknown");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ContentTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ContentTypeEnum value : ContentTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ContentTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SubTypeEnumDeserializer.class)
    public static enum SubTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        IMAGE("Image"),
        VIDEO("Video"),
        AUDIO("Audio"),
        FILE("File"),
        LINK("Link"),
        MENTION("Mention"),
        REPLY("Reply"),
        BUTTON("Button"),
        QUICKREPLY("QuickReply"),
        POSTBACK("Postback"),
        UNKNOWN("Unknown");

        private String value;

        private SubTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SubTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SubTypeEnum value : SubTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SubTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SubTypeEnumDeserializer
    extends StdDeserializer<SubTypeEnum> {
        public SubTypeEnumDeserializer() {
            super(SubTypeEnumDeserializer.class);
        }

        public SubTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SubTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ContentTypeEnumDeserializer
    extends StdDeserializer<ContentTypeEnum> {
        public ContentTypeEnumDeserializer() {
            super(ContentTypeEnumDeserializer.class);
        }

        public ContentTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ContentTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

