/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ContactBulkSearchCriteria;
import com.mypurecloud.sdk.v2.model.DialerContact;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ContactBulkEditRequest
implements Serializable {
    private String contactListFilterId = null;
    private ContactBulkSearchCriteria criteria = null;
    private List<String> contactIds = null;
    private DialerContact contact = null;
    private Boolean generateDownloadURI = null;

    public ContactBulkEditRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.contactIds = new ArrayList<String>();
        }
    }

    public ContactBulkEditRequest contactListFilterId(String contactListFilterId) {
        this.contactListFilterId = contactListFilterId;
        return this;
    }

    @ApiModelProperty(example="null", value="Contact List Filter ID.")
    @JsonProperty(value="contactListFilterId")
    public String getContactListFilterId() {
        return this.contactListFilterId;
    }

    public void setContactListFilterId(String contactListFilterId) {
        this.contactListFilterId = contactListFilterId;
    }

    public ContactBulkEditRequest criteria(ContactBulkSearchCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    @ApiModelProperty(example="null", value="Criteria to filter the contacts by.")
    @JsonProperty(value="criteria")
    public ContactBulkSearchCriteria getCriteria() {
        return this.criteria;
    }

    public void setCriteria(ContactBulkSearchCriteria criteria) {
        this.criteria = criteria;
    }

    public ContactBulkEditRequest contactIds(List<String> contactIds) {
        this.contactIds = contactIds;
        return this;
    }

    @ApiModelProperty(example="null", value="Contact IDs to be bulk edited.")
    @JsonProperty(value="contactIds")
    public List<String> getContactIds() {
        return this.contactIds;
    }

    public void setContactIds(List<String> contactIds) {
        this.contactIds = contactIds;
    }

    public ContactBulkEditRequest contact(DialerContact contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(example="null", value="Contact object with details of fields used for patching.")
    @JsonProperty(value="contact")
    public DialerContact getContact() {
        return this.contact;
    }

    public void setContact(DialerContact contact) {
        this.contact = contact;
    }

    public ContactBulkEditRequest generateDownloadURI(Boolean generateDownloadURI) {
        this.generateDownloadURI = generateDownloadURI;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to do backup export as part of Bulk Operation or not. Default: true.")
    @JsonProperty(value="generateDownloadURI")
    public Boolean getGenerateDownloadURI() {
        return this.generateDownloadURI;
    }

    public void setGenerateDownloadURI(Boolean generateDownloadURI) {
        this.generateDownloadURI = generateDownloadURI;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactBulkEditRequest contactBulkEditRequest = (ContactBulkEditRequest)o;
        return Objects.equals(this.contactListFilterId, contactBulkEditRequest.contactListFilterId) && Objects.equals(this.criteria, contactBulkEditRequest.criteria) && Objects.equals(this.contactIds, contactBulkEditRequest.contactIds) && Objects.equals(this.contact, contactBulkEditRequest.contact) && Objects.equals(this.generateDownloadURI, contactBulkEditRequest.generateDownloadURI);
    }

    public int hashCode() {
        return Objects.hash(this.contactListFilterId, this.criteria, this.contactIds, this.contact, this.generateDownloadURI);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContactBulkEditRequest {\n");
        sb.append("    contactListFilterId: ").append(this.toIndentedString(this.contactListFilterId)).append("\n");
        sb.append("    criteria: ").append(this.toIndentedString(this.criteria)).append("\n");
        sb.append("    contactIds: ").append(this.toIndentedString(this.contactIds)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    generateDownloadURI: ").append(this.toIndentedString(this.generateDownloadURI)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

