/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.CoachingAppointmentResponse;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class CoachingNotification
implements Serializable {
    private String id = null;
    private String name = null;
    private Boolean markedAsRead = null;
    private ActionTypeEnum actionType = null;
    private RelationshipEnum relationship = null;
    private Date dateStart = null;
    private Integer lengthInMinutes = null;
    private StatusEnum status = null;
    private UserReference user = null;
    private CoachingAppointmentResponse appointment = null;
    private String selfUri = null;

    public CoachingNotification() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The name of the appointment for this notification.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public CoachingNotification markedAsRead(Boolean markedAsRead) {
        this.markedAsRead = markedAsRead;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if notification is read or unread")
    @JsonProperty(value="markedAsRead")
    public Boolean getMarkedAsRead() {
        return this.markedAsRead;
    }

    public void setMarkedAsRead(Boolean markedAsRead) {
        this.markedAsRead = markedAsRead;
    }

    @ApiModelProperty(example="null", value="Action causing the notification.")
    @JsonProperty(value="actionType")
    public ActionTypeEnum getActionType() {
        return this.actionType;
    }

    @ApiModelProperty(example="null", value="The relationship of this user to this notification's appointment")
    @JsonProperty(value="relationship")
    public RelationshipEnum getRelationship() {
        return this.relationship;
    }

    @ApiModelProperty(example="null", value="The start time of the appointment relating to this notification. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateStart")
    public Date getDateStart() {
        return this.dateStart;
    }

    @ApiModelProperty(example="null", value="The duration of the appointment on this notification")
    @JsonProperty(value="lengthInMinutes")
    public Integer getLengthInMinutes() {
        return this.lengthInMinutes;
    }

    @ApiModelProperty(example="null", value="The status of the appointment for this notification")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    @ApiModelProperty(example="null", value="The user of this notification")
    @JsonProperty(value="user")
    public UserReference getUser() {
        return this.user;
    }

    @ApiModelProperty(example="null", value="The appointment")
    @JsonProperty(value="appointment")
    public CoachingAppointmentResponse getAppointment() {
        return this.appointment;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoachingNotification coachingNotification = (CoachingNotification)o;
        return Objects.equals(this.id, coachingNotification.id) && Objects.equals(this.name, coachingNotification.name) && Objects.equals(this.markedAsRead, coachingNotification.markedAsRead) && Objects.equals((Object)this.actionType, (Object)coachingNotification.actionType) && Objects.equals((Object)this.relationship, (Object)coachingNotification.relationship) && Objects.equals(this.dateStart, coachingNotification.dateStart) && Objects.equals(this.lengthInMinutes, coachingNotification.lengthInMinutes) && Objects.equals((Object)this.status, (Object)coachingNotification.status) && Objects.equals(this.user, coachingNotification.user) && Objects.equals(this.appointment, coachingNotification.appointment) && Objects.equals(this.selfUri, coachingNotification.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.markedAsRead, this.actionType, this.relationship, this.dateStart, this.lengthInMinutes, this.status, this.user, this.appointment, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CoachingNotification {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    markedAsRead: ").append(this.toIndentedString(this.markedAsRead)).append("\n");
        sb.append("    actionType: ").append(this.toIndentedString((Object)this.actionType)).append("\n");
        sb.append("    relationship: ").append(this.toIndentedString((Object)this.relationship)).append("\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("    lengthInMinutes: ").append(this.toIndentedString(this.lengthInMinutes)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    appointment: ").append(this.toIndentedString(this.appointment)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActionTypeEnumDeserializer.class)
    public static enum ActionTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CREATE("Create"),
        UPDATE("Update"),
        DELETE("Delete"),
        STATUSCHANGE("StatusChange");

        private String value;

        private ActionTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionTypeEnum value : ActionTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=RelationshipEnumDeserializer.class)
    public static enum RelationshipEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ATTENDEE("Attendee"),
        CREATOR("Creator"),
        FACILITATOR("Facilitator");

        private String value;

        private RelationshipEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RelationshipEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RelationshipEnum value : RelationshipEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RelationshipEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SCHEDULED("Scheduled"),
        INPROGRESS("InProgress"),
        COMPLETED("Completed"),
        INVALIDSCHEDULE("InvalidSchedule");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class RelationshipEnumDeserializer
    extends StdDeserializer<RelationshipEnum> {
        public RelationshipEnumDeserializer() {
            super(RelationshipEnumDeserializer.class);
        }

        public RelationshipEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RelationshipEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ActionTypeEnumDeserializer
    extends StdDeserializer<ActionTypeEnum> {
        public ActionTypeEnumDeserializer() {
            super(ActionTypeEnumDeserializer.class);
        }

        public ActionTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

