/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AlternativeShiftScheduleLookup;
import com.mypurecloud.sdk.v2.model.InitiatingAlternativeShift;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AlternativeShiftSearchOffersRequest
implements Serializable {
    private AlternativeShiftScheduleLookup schedule = null;
    private LocalDate queryWeekDate = null;
    private InitiatingAlternativeShift initiatingShift = null;
    private List<String> acceptableIntervals = null;

    public AlternativeShiftSearchOffersRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.acceptableIntervals = new ArrayList<String>();
        }
    }

    public AlternativeShiftSearchOffersRequest schedule(AlternativeShiftScheduleLookup schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The existing schedule being used to find alternative shift offers")
    @JsonProperty(value="schedule")
    public AlternativeShiftScheduleLookup getSchedule() {
        return this.schedule;
    }

    public void setSchedule(AlternativeShiftScheduleLookup schedule) {
        this.schedule = schedule;
    }

    public AlternativeShiftSearchOffersRequest queryWeekDate(LocalDate queryWeekDate) {
        this.queryWeekDate = queryWeekDate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The start date for the week in this schedule in yyyy-MM-dd format. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd")
    @JsonProperty(value="queryWeekDate")
    public LocalDate getQueryWeekDate() {
        return this.queryWeekDate;
    }

    public void setQueryWeekDate(LocalDate queryWeekDate) {
        this.queryWeekDate = queryWeekDate;
    }

    public AlternativeShiftSearchOffersRequest initiatingShift(InitiatingAlternativeShift initiatingShift) {
        this.initiatingShift = initiatingShift;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The shift a user puts up for alternative shift offers")
    @JsonProperty(value="initiatingShift")
    public InitiatingAlternativeShift getInitiatingShift() {
        return this.initiatingShift;
    }

    public void setInitiatingShift(InitiatingAlternativeShift initiatingShift) {
        this.initiatingShift = initiatingShift;
    }

    public AlternativeShiftSearchOffersRequest acceptableIntervals(List<String> acceptableIntervals) {
        this.acceptableIntervals = acceptableIntervals;
        return this;
    }

    @ApiModelProperty(example="null", value="The acceptable intervals in offers. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="acceptableIntervals")
    public List<String> getAcceptableIntervals() {
        return this.acceptableIntervals;
    }

    public void setAcceptableIntervals(List<String> acceptableIntervals) {
        this.acceptableIntervals = acceptableIntervals;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlternativeShiftSearchOffersRequest alternativeShiftSearchOffersRequest = (AlternativeShiftSearchOffersRequest)o;
        return Objects.equals(this.schedule, alternativeShiftSearchOffersRequest.schedule) && Objects.equals(this.queryWeekDate, alternativeShiftSearchOffersRequest.queryWeekDate) && Objects.equals(this.initiatingShift, alternativeShiftSearchOffersRequest.initiatingShift) && Objects.equals(this.acceptableIntervals, alternativeShiftSearchOffersRequest.acceptableIntervals);
    }

    public int hashCode() {
        return Objects.hash(this.schedule, this.queryWeekDate, this.initiatingShift, this.acceptableIntervals);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlternativeShiftSearchOffersRequest {\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    queryWeekDate: ").append(this.toIndentedString(this.queryWeekDate)).append("\n");
        sb.append("    initiatingShift: ").append(this.toIndentedString(this.initiatingShift)).append("\n");
        sb.append("    acceptableIntervals: ").append(this.toIndentedString(this.acceptableIntervals)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

