/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class AiScoring
implements Serializable {
    private FailureTypeEnum failureType = null;
    private Boolean pending = null;
    private Date dateLastChanged = null;

    public AiScoring() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The type of error that occurred while processing AI scores. It is null where there is no error.")
    @JsonProperty(value="failureType")
    public FailureTypeEnum getFailureType() {
        return this.failureType;
    }

    @ApiModelProperty(example="null", value="Indicates whether AI scoring is currently processing the evaluation.")
    @JsonProperty(value="pending")
    public Boolean getPending() {
        return this.pending;
    }

    @ApiModelProperty(example="null", value="The date when the AI scores were last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateLastChanged")
    public Date getDateLastChanged() {
        return this.dateLastChanged;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AiScoring aiScoring = (AiScoring)o;
        return Objects.equals((Object)this.failureType, (Object)aiScoring.failureType) && Objects.equals(this.pending, aiScoring.pending) && Objects.equals(this.dateLastChanged, aiScoring.dateLastChanged);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.failureType, this.pending, this.dateLastChanged});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AiScoring {\n");
        sb.append("    failureType: ").append(this.toIndentedString((Object)this.failureType)).append("\n");
        sb.append("    pending: ").append(this.toIndentedString(this.pending)).append("\n");
        sb.append("    dateLastChanged: ").append(this.toIndentedString(this.dateLastChanged)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FailureTypeEnumDeserializer.class)
    public static enum FailureTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        QUOTAREACHED("QuotaReached"),
        PARSINGERROR("ParsingError"),
        SERVICEERROR("ServiceError"),
        INVALIDREQUEST("InvalidRequest"),
        DUPLICATEFORMSAMEAGENT("DuplicateFormSameAgent"),
        UNAUTHORIZED("Unauthorized");

        private String value;

        private FailureTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FailureTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FailureTypeEnum value : FailureTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FailureTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FailureTypeEnumDeserializer
    extends StdDeserializer<FailureTypeEnum> {
        public FailureTypeEnumDeserializer() {
            super(FailureTypeEnumDeserializer.class);
        }

        public FailureTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FailureTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

