/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteGuideJobsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGuideJobRequest;
import com.mypurecloud.sdk.v2.api.request.GetGuideRequest;
import com.mypurecloud.sdk.v2.api.request.GetGuideVersionJobRequest;
import com.mypurecloud.sdk.v2.api.request.GetGuideVersionRequest;
import com.mypurecloud.sdk.v2.api.request.GetGuidesJobRequest;
import com.mypurecloud.sdk.v2.api.request.GetGuidesRequest;
import com.mypurecloud.sdk.v2.api.request.PatchGuideVersionRequest;
import com.mypurecloud.sdk.v2.api.request.PostGuideVersionJobsRequest;
import com.mypurecloud.sdk.v2.api.request.PostGuideVersionsRequest;
import com.mypurecloud.sdk.v2.api.request.PostGuidesJobsRequest;
import com.mypurecloud.sdk.v2.api.request.PostGuidesRequest;
import com.mypurecloud.sdk.v2.model.CreateGuide;
import com.mypurecloud.sdk.v2.model.CreateGuideVersion;
import com.mypurecloud.sdk.v2.model.GenerateGuideContentRequest;
import com.mypurecloud.sdk.v2.model.Guide;
import com.mypurecloud.sdk.v2.model.GuideContentGenerationJob;
import com.mypurecloud.sdk.v2.model.GuideEntityListing;
import com.mypurecloud.sdk.v2.model.GuideJob;
import com.mypurecloud.sdk.v2.model.GuideVersion;
import com.mypurecloud.sdk.v2.model.GuideVersionPublishJob;
import com.mypurecloud.sdk.v2.model.GuideVersionPublishJobRequest;
import com.mypurecloud.sdk.v2.model.UpdateGuideVersion;
import java.io.IOException;

public class AIStudioApi {
    private final ApiClient pcapiClient;

    public AIStudioApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AIStudioApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public GuideJob deleteGuideJobs(String guideId) throws IOException, ApiException {
        return this.deleteGuideJobs(this.createDeleteGuideJobsRequest(guideId));
    }

    public ApiResponse<GuideJob> deleteGuideJobsWithHttpInfo(String guideId) throws IOException {
        return this.deleteGuideJobs(this.createDeleteGuideJobsRequest(guideId).withHttpInfo());
    }

    private DeleteGuideJobsRequest createDeleteGuideJobsRequest(String guideId) {
        return DeleteGuideJobsRequest.builder().withGuideId(guideId).build();
    }

    public GuideJob deleteGuideJobs(DeleteGuideJobsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GuideJob> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GuideJob>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GuideJob> deleteGuideJobs(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GuideJob>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Guide getGuide(String guideId) throws IOException, ApiException {
        return this.getGuide(this.createGetGuideRequest(guideId));
    }

    public ApiResponse<Guide> getGuideWithHttpInfo(String guideId) throws IOException {
        return this.getGuide(this.createGetGuideRequest(guideId).withHttpInfo());
    }

    private GetGuideRequest createGetGuideRequest(String guideId) {
        return GetGuideRequest.builder().withGuideId(guideId).build();
    }

    public Guide getGuide(GetGuideRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Guide> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Guide>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Guide> getGuide(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Guide>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GuideJob getGuideJob(String guideId, String jobId) throws IOException, ApiException {
        return this.getGuideJob(this.createGetGuideJobRequest(guideId, jobId));
    }

    public ApiResponse<GuideJob> getGuideJobWithHttpInfo(String guideId, String jobId) throws IOException {
        return this.getGuideJob(this.createGetGuideJobRequest(guideId, jobId).withHttpInfo());
    }

    private GetGuideJobRequest createGetGuideJobRequest(String guideId, String jobId) {
        return GetGuideJobRequest.builder().withGuideId(guideId).withJobId(jobId).build();
    }

    public GuideJob getGuideJob(GetGuideJobRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GuideJob> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GuideJob>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GuideJob> getGuideJob(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GuideJob>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GuideVersion getGuideVersion(String guideId, String versionId) throws IOException, ApiException {
        return this.getGuideVersion(this.createGetGuideVersionRequest(guideId, versionId));
    }

    public ApiResponse<GuideVersion> getGuideVersionWithHttpInfo(String guideId, String versionId) throws IOException {
        return this.getGuideVersion(this.createGetGuideVersionRequest(guideId, versionId).withHttpInfo());
    }

    private GetGuideVersionRequest createGetGuideVersionRequest(String guideId, String versionId) {
        return GetGuideVersionRequest.builder().withGuideId(guideId).withVersionId(versionId).build();
    }

    public GuideVersion getGuideVersion(GetGuideVersionRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GuideVersion> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GuideVersion>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GuideVersion> getGuideVersion(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GuideVersion>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GuideVersionPublishJob getGuideVersionJob(String guideId, String versionId, String jobId) throws IOException, ApiException {
        return this.getGuideVersionJob(this.createGetGuideVersionJobRequest(guideId, versionId, jobId));
    }

    public ApiResponse<GuideVersionPublishJob> getGuideVersionJobWithHttpInfo(String guideId, String versionId, String jobId) throws IOException {
        return this.getGuideVersionJob(this.createGetGuideVersionJobRequest(guideId, versionId, jobId).withHttpInfo());
    }

    private GetGuideVersionJobRequest createGetGuideVersionJobRequest(String guideId, String versionId, String jobId) {
        return GetGuideVersionJobRequest.builder().withGuideId(guideId).withVersionId(versionId).withJobId(jobId).build();
    }

    public GuideVersionPublishJob getGuideVersionJob(GetGuideVersionJobRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GuideVersionPublishJob> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GuideVersionPublishJob>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GuideVersionPublishJob> getGuideVersionJob(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GuideVersionPublishJob>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GuideEntityListing getGuides(String name, String nameContains, String status, String sortBy, String sortOrder, Integer pageNumber, Integer pageSize) throws IOException, ApiException {
        return this.getGuides(this.createGetGuidesRequest(name, nameContains, status, sortBy, sortOrder, pageNumber, pageSize));
    }

    public ApiResponse<GuideEntityListing> getGuidesWithHttpInfo(String name, String nameContains, String status, String sortBy, String sortOrder, Integer pageNumber, Integer pageSize) throws IOException {
        return this.getGuides(this.createGetGuidesRequest(name, nameContains, status, sortBy, sortOrder, pageNumber, pageSize).withHttpInfo());
    }

    private GetGuidesRequest createGetGuidesRequest(String name, String nameContains, String status, String sortBy, String sortOrder, Integer pageNumber, Integer pageSize) {
        return GetGuidesRequest.builder().withName(name).withNameContains(nameContains).withStatus(status).withSortBy(sortBy).withSortOrder(sortOrder).withPageNumber(pageNumber).withPageSize(pageSize).build();
    }

    public GuideEntityListing getGuides(GetGuidesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GuideEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GuideEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GuideEntityListing> getGuides(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GuideEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GuideContentGenerationJob getGuidesJob(String jobId) throws IOException, ApiException {
        return this.getGuidesJob(this.createGetGuidesJobRequest(jobId));
    }

    public ApiResponse<GuideContentGenerationJob> getGuidesJobWithHttpInfo(String jobId) throws IOException {
        return this.getGuidesJob(this.createGetGuidesJobRequest(jobId).withHttpInfo());
    }

    private GetGuidesJobRequest createGetGuidesJobRequest(String jobId) {
        return GetGuidesJobRequest.builder().withJobId(jobId).build();
    }

    public GuideContentGenerationJob getGuidesJob(GetGuidesJobRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GuideContentGenerationJob> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GuideContentGenerationJob>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GuideContentGenerationJob> getGuidesJob(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GuideContentGenerationJob>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GuideVersion patchGuideVersion(String guideId, String versionId, UpdateGuideVersion body) throws IOException, ApiException {
        return this.patchGuideVersion(this.createPatchGuideVersionRequest(guideId, versionId, body));
    }

    public ApiResponse<GuideVersion> patchGuideVersionWithHttpInfo(String guideId, String versionId, UpdateGuideVersion body) throws IOException {
        return this.patchGuideVersion(this.createPatchGuideVersionRequest(guideId, versionId, body).withHttpInfo());
    }

    private PatchGuideVersionRequest createPatchGuideVersionRequest(String guideId, String versionId, UpdateGuideVersion body) {
        return PatchGuideVersionRequest.builder().withGuideId(guideId).withVersionId(versionId).withBody(body).build();
    }

    public GuideVersion patchGuideVersion(PatchGuideVersionRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GuideVersion> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GuideVersion>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GuideVersion> patchGuideVersion(ApiRequest<UpdateGuideVersion> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GuideVersion>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GuideVersionPublishJob postGuideVersionJobs(String guideId, String versionId, GuideVersionPublishJobRequest body) throws IOException, ApiException {
        return this.postGuideVersionJobs(this.createPostGuideVersionJobsRequest(guideId, versionId, body));
    }

    public ApiResponse<GuideVersionPublishJob> postGuideVersionJobsWithHttpInfo(String guideId, String versionId, GuideVersionPublishJobRequest body) throws IOException {
        return this.postGuideVersionJobs(this.createPostGuideVersionJobsRequest(guideId, versionId, body).withHttpInfo());
    }

    private PostGuideVersionJobsRequest createPostGuideVersionJobsRequest(String guideId, String versionId, GuideVersionPublishJobRequest body) {
        return PostGuideVersionJobsRequest.builder().withGuideId(guideId).withVersionId(versionId).withBody(body).build();
    }

    public GuideVersionPublishJob postGuideVersionJobs(PostGuideVersionJobsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GuideVersionPublishJob> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GuideVersionPublishJob>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GuideVersionPublishJob> postGuideVersionJobs(ApiRequest<GuideVersionPublishJobRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GuideVersionPublishJob>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GuideVersion postGuideVersions(String guideId, CreateGuideVersion body) throws IOException, ApiException {
        return this.postGuideVersions(this.createPostGuideVersionsRequest(guideId, body));
    }

    public ApiResponse<GuideVersion> postGuideVersionsWithHttpInfo(String guideId, CreateGuideVersion body) throws IOException {
        return this.postGuideVersions(this.createPostGuideVersionsRequest(guideId, body).withHttpInfo());
    }

    private PostGuideVersionsRequest createPostGuideVersionsRequest(String guideId, CreateGuideVersion body) {
        return PostGuideVersionsRequest.builder().withGuideId(guideId).withBody(body).build();
    }

    public GuideVersion postGuideVersions(PostGuideVersionsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GuideVersion> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GuideVersion>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GuideVersion> postGuideVersions(ApiRequest<CreateGuideVersion> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GuideVersion>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Guide postGuides(CreateGuide body) throws IOException, ApiException {
        return this.postGuides(this.createPostGuidesRequest(body));
    }

    public ApiResponse<Guide> postGuidesWithHttpInfo(CreateGuide body) throws IOException {
        return this.postGuides(this.createPostGuidesRequest(body).withHttpInfo());
    }

    private PostGuidesRequest createPostGuidesRequest(CreateGuide body) {
        return PostGuidesRequest.builder().withBody(body).build();
    }

    public Guide postGuides(PostGuidesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Guide> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Guide>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Guide> postGuides(ApiRequest<CreateGuide> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Guide>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GuideContentGenerationJob postGuidesJobs(GenerateGuideContentRequest body) throws IOException, ApiException {
        return this.postGuidesJobs(this.createPostGuidesJobsRequest(body));
    }

    public ApiResponse<GuideContentGenerationJob> postGuidesJobsWithHttpInfo(GenerateGuideContentRequest body) throws IOException {
        return this.postGuidesJobs(this.createPostGuidesJobsRequest(body).withHttpInfo());
    }

    private PostGuidesJobsRequest createPostGuidesJobsRequest(GenerateGuideContentRequest body) {
        return PostGuidesJobsRequest.builder().withBody(body).build();
    }

    public GuideContentGenerationJob postGuidesJobs(PostGuidesJobsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GuideContentGenerationJob> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GuideContentGenerationJob>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GuideContentGenerationJob> postGuidesJobs(ApiRequest<GenerateGuideContentRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GuideContentGenerationJob>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

