/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkitemCommonCreate
implements Serializable {
    private String name = null;
    private Integer priority = null;
    private Date dateDue = null;
    private Date dateExpires = null;
    private Integer durationSeconds = null;
    private Integer ttl = null;
    private String statusId = null;
    private String workbinId = null;
    private Boolean autoStatusTransition = null;
    private String description = null;
    private String typeId = null;
    private Map<String, Object> customFields = null;
    private String queueId = null;
    private String assigneeId = null;
    private String languageId = null;
    private String externalContactId = null;
    private String externalTag = null;
    private List<String> skillIds = null;
    private String scriptId = null;

    public WorkitemCommonCreate() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.skillIds = new ArrayList<String>();
        }
    }

    public WorkitemCommonCreate name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the Workitem. Valid length between 3 and 256 characters.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkitemCommonCreate priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(example="null", value="The priority of the Workitem. The valid range is between -25,000,000 and 25,000,000.")
    @JsonProperty(value="priority")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public WorkitemCommonCreate dateDue(Date dateDue) {
        this.dateDue = dateDue;
        return this;
    }

    @ApiModelProperty(example="null", value="The due date of the Workitem. Can not be greater than 365 days from the current time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateDue")
    public Date getDateDue() {
        return this.dateDue;
    }

    public void setDateDue(Date dateDue) {
        this.dateDue = dateDue;
    }

    public WorkitemCommonCreate dateExpires(Date dateExpires) {
        this.dateExpires = dateExpires;
        return this;
    }

    @ApiModelProperty(example="null", value="The expiry date of the Workitem. Can not be greater than 365 days from the current time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateExpires")
    public Date getDateExpires() {
        return this.dateExpires;
    }

    public void setDateExpires(Date dateExpires) {
        this.dateExpires = dateExpires;
    }

    public WorkitemCommonCreate durationSeconds(Integer durationSeconds) {
        this.durationSeconds = durationSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="The estimated duration in seconds to complete the Workitem. Maximum of 365 days.")
    @JsonProperty(value="durationSeconds")
    public Integer getDurationSeconds() {
        return this.durationSeconds;
    }

    public void setDurationSeconds(Integer durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public WorkitemCommonCreate ttl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    @ApiModelProperty(example="null", value="The epoch timestamp in seconds specifying the time to live for the Workitem. Can not be greater than 365 days from the current time.")
    @JsonProperty(value="ttl")
    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public WorkitemCommonCreate statusId(String statusId) {
        this.statusId = statusId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the Status of the Workitem.")
    @JsonProperty(value="statusId")
    public String getStatusId() {
        return this.statusId;
    }

    public void setStatusId(String statusId) {
        this.statusId = statusId;
    }

    public WorkitemCommonCreate workbinId(String workbinId) {
        this.workbinId = workbinId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of Workbin that contains the Workitem.")
    @JsonProperty(value="workbinId")
    public String getWorkbinId() {
        return this.workbinId;
    }

    public void setWorkbinId(String workbinId) {
        this.workbinId = workbinId;
    }

    public WorkitemCommonCreate autoStatusTransition(Boolean autoStatusTransition) {
        this.autoStatusTransition = autoStatusTransition;
        return this;
    }

    @ApiModelProperty(example="null", value="Set it to false to disable auto status transition. By default, it is enabled.")
    @JsonProperty(value="autoStatusTransition")
    public Boolean getAutoStatusTransition() {
        return this.autoStatusTransition;
    }

    public void setAutoStatusTransition(Boolean autoStatusTransition) {
        this.autoStatusTransition = autoStatusTransition;
    }

    public WorkitemCommonCreate description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the Workitem. Maximum length of 512 characters.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WorkitemCommonCreate typeId(String typeId) {
        this.typeId = typeId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the Worktype of the Workitem.")
    @JsonProperty(value="typeId")
    public String getTypeId() {
        return this.typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public WorkitemCommonCreate customFields(Map<String, Object> customFields) {
        this.customFields = customFields;
        return this;
    }

    @ApiModelProperty(example="null", value="Custom fields defined in the schema referenced by the worktype of the workitem.")
    @JsonProperty(value="customFields")
    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public WorkitemCommonCreate queueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the Workitems queue. Must be a valid UUID.")
    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public WorkitemCommonCreate assigneeId(String assigneeId) {
        this.assigneeId = assigneeId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the assignee of the Workitem. Must be a valid UUID.")
    @JsonProperty(value="assigneeId")
    public String getAssigneeId() {
        return this.assigneeId;
    }

    public void setAssigneeId(String assigneeId) {
        this.assigneeId = assigneeId;
    }

    public WorkitemCommonCreate languageId(String languageId) {
        this.languageId = languageId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of language of the Workitem. Must be a valid UUID.")
    @JsonProperty(value="languageId")
    public String getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(String languageId) {
        this.languageId = languageId;
    }

    public WorkitemCommonCreate externalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the external contact of the Workitem. Must be a valid UUID.")
    @JsonProperty(value="externalContactId")
    public String getExternalContactId() {
        return this.externalContactId;
    }

    public void setExternalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
    }

    public WorkitemCommonCreate externalTag(String externalTag) {
        this.externalTag = externalTag;
        return this;
    }

    @ApiModelProperty(example="null", value="The external tag of the Workitem.")
    @JsonProperty(value="externalTag")
    public String getExternalTag() {
        return this.externalTag;
    }

    public void setExternalTag(String externalTag) {
        this.externalTag = externalTag;
    }

    public WorkitemCommonCreate skillIds(List<String> skillIds) {
        this.skillIds = skillIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The skill IDs of the Workitem. Must be valid UUIDs.")
    @JsonProperty(value="skillIds")
    public List<String> getSkillIds() {
        return this.skillIds;
    }

    public void setSkillIds(List<String> skillIds) {
        this.skillIds = skillIds;
    }

    public WorkitemCommonCreate scriptId(String scriptId) {
        this.scriptId = scriptId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the Workitems script. Must be a valid UUID.")
    @JsonProperty(value="scriptId")
    public String getScriptId() {
        return this.scriptId;
    }

    public void setScriptId(String scriptId) {
        this.scriptId = scriptId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkitemCommonCreate workitemCommonCreate = (WorkitemCommonCreate)o;
        return Objects.equals(this.name, workitemCommonCreate.name) && Objects.equals(this.priority, workitemCommonCreate.priority) && Objects.equals(this.dateDue, workitemCommonCreate.dateDue) && Objects.equals(this.dateExpires, workitemCommonCreate.dateExpires) && Objects.equals(this.durationSeconds, workitemCommonCreate.durationSeconds) && Objects.equals(this.ttl, workitemCommonCreate.ttl) && Objects.equals(this.statusId, workitemCommonCreate.statusId) && Objects.equals(this.workbinId, workitemCommonCreate.workbinId) && Objects.equals(this.autoStatusTransition, workitemCommonCreate.autoStatusTransition) && Objects.equals(this.description, workitemCommonCreate.description) && Objects.equals(this.typeId, workitemCommonCreate.typeId) && Objects.equals(this.customFields, workitemCommonCreate.customFields) && Objects.equals(this.queueId, workitemCommonCreate.queueId) && Objects.equals(this.assigneeId, workitemCommonCreate.assigneeId) && Objects.equals(this.languageId, workitemCommonCreate.languageId) && Objects.equals(this.externalContactId, workitemCommonCreate.externalContactId) && Objects.equals(this.externalTag, workitemCommonCreate.externalTag) && Objects.equals(this.skillIds, workitemCommonCreate.skillIds) && Objects.equals(this.scriptId, workitemCommonCreate.scriptId);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.priority, this.dateDue, this.dateExpires, this.durationSeconds, this.ttl, this.statusId, this.workbinId, this.autoStatusTransition, this.description, this.typeId, this.customFields, this.queueId, this.assigneeId, this.languageId, this.externalContactId, this.externalTag, this.skillIds, this.scriptId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkitemCommonCreate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    dateDue: ").append(this.toIndentedString(this.dateDue)).append("\n");
        sb.append("    dateExpires: ").append(this.toIndentedString(this.dateExpires)).append("\n");
        sb.append("    durationSeconds: ").append(this.toIndentedString(this.durationSeconds)).append("\n");
        sb.append("    ttl: ").append(this.toIndentedString(this.ttl)).append("\n");
        sb.append("    statusId: ").append(this.toIndentedString(this.statusId)).append("\n");
        sb.append("    workbinId: ").append(this.toIndentedString(this.workbinId)).append("\n");
        sb.append("    autoStatusTransition: ").append(this.toIndentedString(this.autoStatusTransition)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    queueId: ").append(this.toIndentedString(this.queueId)).append("\n");
        sb.append("    assigneeId: ").append(this.toIndentedString(this.assigneeId)).append("\n");
        sb.append("    languageId: ").append(this.toIndentedString(this.languageId)).append("\n");
        sb.append("    externalContactId: ").append(this.toIndentedString(this.externalContactId)).append("\n");
        sb.append("    externalTag: ").append(this.toIndentedString(this.externalTag)).append("\n");
        sb.append("    skillIds: ").append(this.toIndentedString(this.skillIds)).append("\n");
        sb.append("    scriptId: ").append(this.toIndentedString(this.scriptId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

