/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.BidGroupWorkPlanResponse;
import com.mypurecloud.sdk.v2.model.ManagementUnitReference;
import com.mypurecloud.sdk.v2.model.PlanningGroupReference;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WorkPlanBidGroup
implements Serializable {
    private String name = null;
    private ManagementUnitReference managementUnit = null;
    private List<UserReference> agents = null;
    private List<BidGroupWorkPlanResponse> workPlans = null;
    private List<PlanningGroupReference> planningGroups = null;

    public WorkPlanBidGroup() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.agents = new ArrayList<UserReference>();
            this.workPlans = new ArrayList<BidGroupWorkPlanResponse>();
            this.planningGroups = new ArrayList<PlanningGroupReference>();
        }
    }

    public WorkPlanBidGroup name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the work plan bid group")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkPlanBidGroup managementUnit(ManagementUnitReference managementUnit) {
        this.managementUnit = managementUnit;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The management unit this bid group belongs to")
    @JsonProperty(value="managementUnit")
    public ManagementUnitReference getManagementUnit() {
        return this.managementUnit;
    }

    public void setManagementUnit(ManagementUnitReference managementUnit) {
        this.managementUnit = managementUnit;
    }

    public WorkPlanBidGroup agents(List<UserReference> agents) {
        this.agents = agents;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The list of agents who participate in this bid group")
    @JsonProperty(value="agents")
    public List<UserReference> getAgents() {
        return this.agents;
    }

    public void setAgents(List<UserReference> agents) {
        this.agents = agents;
    }

    public WorkPlanBidGroup workPlans(List<BidGroupWorkPlanResponse> workPlans) {
        this.workPlans = workPlans;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The list of work plans used in this bid group")
    @JsonProperty(value="workPlans")
    public List<BidGroupWorkPlanResponse> getWorkPlans() {
        return this.workPlans;
    }

    public void setWorkPlans(List<BidGroupWorkPlanResponse> workPlans) {
        this.workPlans = workPlans;
    }

    public WorkPlanBidGroup planningGroups(List<PlanningGroupReference> planningGroups) {
        this.planningGroups = planningGroups;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The list of planning groups selected in this bid group")
    @JsonProperty(value="planningGroups")
    public List<PlanningGroupReference> getPlanningGroups() {
        return this.planningGroups;
    }

    public void setPlanningGroups(List<PlanningGroupReference> planningGroups) {
        this.planningGroups = planningGroups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkPlanBidGroup workPlanBidGroup = (WorkPlanBidGroup)o;
        return Objects.equals(this.name, workPlanBidGroup.name) && Objects.equals(this.managementUnit, workPlanBidGroup.managementUnit) && Objects.equals(this.agents, workPlanBidGroup.agents) && Objects.equals(this.workPlans, workPlanBidGroup.workPlans) && Objects.equals(this.planningGroups, workPlanBidGroup.planningGroups);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.managementUnit, this.agents, this.workPlans, this.planningGroups);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkPlanBidGroup {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    managementUnit: ").append(this.toIndentedString(this.managementUnit)).append("\n");
        sb.append("    agents: ").append(this.toIndentedString(this.agents)).append("\n");
        sb.append("    workPlans: ").append(this.toIndentedString(this.workPlans)).append("\n");
        sb.append("    planningGroups: ").append(this.toIndentedString(this.planningGroups)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

