/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WebChatRoutingTarget
implements Serializable {
    private TargetTypeEnum targetType = null;
    private String targetAddress = null;
    private List<String> skills = null;
    private String language = null;
    private Long priority = null;

    public WebChatRoutingTarget() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.skills = new ArrayList<String>();
        }
    }

    public WebChatRoutingTarget targetType(TargetTypeEnum targetType) {
        this.targetType = targetType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The target type of the routing target, such as 'QUEUE'.")
    @JsonProperty(value="targetType")
    public TargetTypeEnum getTargetType() {
        return this.targetType;
    }

    public void setTargetType(TargetTypeEnum targetType) {
        this.targetType = targetType;
    }

    public WebChatRoutingTarget targetAddress(String targetAddress) {
        this.targetAddress = targetAddress;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The target of the route, in the format appropriate given the 'targetType'.")
    @JsonProperty(value="targetAddress")
    public String getTargetAddress() {
        return this.targetAddress;
    }

    public void setTargetAddress(String targetAddress) {
        this.targetAddress = targetAddress;
    }

    public WebChatRoutingTarget skills(List<String> skills) {
        this.skills = skills;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of skill names to use for routing.")
    @JsonProperty(value="skills")
    public List<String> getSkills() {
        return this.skills;
    }

    public void setSkills(List<String> skills) {
        this.skills = skills;
    }

    public WebChatRoutingTarget language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", value="The language name to use for routing.")
    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public WebChatRoutingTarget priority(Long priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(example="null", value="The priority to assign to the conversation for routing.")
    @JsonProperty(value="priority")
    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebChatRoutingTarget webChatRoutingTarget = (WebChatRoutingTarget)o;
        return Objects.equals((Object)this.targetType, (Object)webChatRoutingTarget.targetType) && Objects.equals(this.targetAddress, webChatRoutingTarget.targetAddress) && Objects.equals(this.skills, webChatRoutingTarget.skills) && Objects.equals(this.language, webChatRoutingTarget.language) && Objects.equals(this.priority, webChatRoutingTarget.priority);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.targetType, this.targetAddress, this.skills, this.language, this.priority});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebChatRoutingTarget {\n");
        sb.append("    targetType: ").append(this.toIndentedString((Object)this.targetType)).append("\n");
        sb.append("    targetAddress: ").append(this.toIndentedString(this.targetAddress)).append("\n");
        sb.append("    skills: ").append(this.toIndentedString(this.skills)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TargetTypeEnumDeserializer.class)
    public static enum TargetTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        QUEUE("QUEUE");

        private String value;

        private TargetTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TargetTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TargetTypeEnum value : TargetTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TargetTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TargetTypeEnumDeserializer
    extends StdDeserializer<TargetTypeEnum> {
        public TargetTypeEnumDeserializer() {
            super(TargetTypeEnumDeserializer.class);
        }

        public TargetTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TargetTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

