/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class UserNextActivityReminder
implements Serializable {
    private ActivityCategoryEnum activityCategory = null;
    private Date startDate = null;

    public UserNextActivityReminder() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="Upcoming activity for which the user is scheduled")
    @JsonProperty(value="activityCategory")
    public ActivityCategoryEnum getActivityCategory() {
        return this.activityCategory;
    }

    @ApiModelProperty(example="null", value="The start timestamp of the scheduled activity in ISO-8601 format")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserNextActivityReminder userNextActivityReminder = (UserNextActivityReminder)o;
        return Objects.equals((Object)this.activityCategory, (Object)userNextActivityReminder.activityCategory) && Objects.equals(this.startDate, userNextActivityReminder.startDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.activityCategory, this.startDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserNextActivityReminder {\n");
        sb.append("    activityCategory: ").append(this.toIndentedString((Object)this.activityCategory)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActivityCategoryEnumDeserializer.class)
    public static enum ActivityCategoryEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ONQUEUEWORK("OnQueueWork"),
        BREAK("Break"),
        MEAL("Meal"),
        MEETING("Meeting"),
        OFFQUEUEWORK("OffQueueWork"),
        TIMEOFF("TimeOff"),
        TRAINING("Training"),
        UNAVAILABLE("Unavailable"),
        UNSCHEDULED("Unscheduled");

        private String value;

        private ActivityCategoryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActivityCategoryEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActivityCategoryEnum value : ActivityCategoryEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActivityCategoryEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActivityCategoryEnumDeserializer
    extends StdDeserializer<ActivityCategoryEnum> {
        public ActivityCategoryEnumDeserializer() {
            super(ActivityCategoryEnumDeserializer.class);
        }

        public ActivityCategoryEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActivityCategoryEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

