/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.WorkflowTargetSettings;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="The target of a trigger invocation")
public class TriggerTarget
implements Serializable {
    private TypeEnum type = null;
    private String id = null;
    private WorkflowTargetSettings workflowTargetSettings = null;

    public TriggerTarget() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public TriggerTarget type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The entity type to target")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public TriggerTarget id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the entity to target")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TriggerTarget workflowTargetSettings(WorkflowTargetSettings workflowTargetSettings) {
        this.workflowTargetSettings = workflowTargetSettings;
        return this;
    }

    @ApiModelProperty(example="null", value="Optional config for the target.")
    @JsonProperty(value="workflowTargetSettings")
    public WorkflowTargetSettings getWorkflowTargetSettings() {
        return this.workflowTargetSettings;
    }

    public void setWorkflowTargetSettings(WorkflowTargetSettings workflowTargetSettings) {
        this.workflowTargetSettings = workflowTargetSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TriggerTarget triggerTarget = (TriggerTarget)o;
        return Objects.equals((Object)this.type, (Object)triggerTarget.type) && Objects.equals(this.id, triggerTarget.id) && Objects.equals(this.workflowTargetSettings, triggerTarget.workflowTargetSettings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id, this.workflowTargetSettings});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TriggerTarget {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    workflowTargetSettings: ").append(this.toIndentedString(this.workflowTargetSettings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WORKFLOW("Workflow");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

