/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.SalesforceSettings;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class SalesforceSourceRequest
implements Serializable {
    private String id = null;
    private String name = null;
    private String integrationId = null;
    private Integer schedulePeriod = null;
    private SalesforceSettings settings = null;
    private String selfUri = null;

    public SalesforceSourceRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public SalesforceSourceRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the integration source.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SalesforceSourceRequest integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @ApiModelProperty(example="null", value="The integration associated with the source.")
    @JsonProperty(value="integrationId")
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public SalesforceSourceRequest schedulePeriod(Integer schedulePeriod) {
        this.schedulePeriod = schedulePeriod;
        return this;
    }

    @ApiModelProperty(example="null", value="The schedule period of the source in hours. Must be at least 6 and at most 48 hours.")
    @JsonProperty(value="schedulePeriod")
    public Integer getSchedulePeriod() {
        return this.schedulePeriod;
    }

    public void setSchedulePeriod(Integer schedulePeriod) {
        this.schedulePeriod = schedulePeriod;
    }

    public SalesforceSourceRequest settings(SalesforceSettings settings) {
        this.settings = settings;
        return this;
    }

    @ApiModelProperty(example="null", value="The settings of the source.")
    @JsonProperty(value="settings")
    public SalesforceSettings getSettings() {
        return this.settings;
    }

    public void setSettings(SalesforceSettings settings) {
        this.settings = settings;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SalesforceSourceRequest salesforceSourceRequest = (SalesforceSourceRequest)o;
        return Objects.equals(this.id, salesforceSourceRequest.id) && Objects.equals(this.name, salesforceSourceRequest.name) && Objects.equals(this.integrationId, salesforceSourceRequest.integrationId) && Objects.equals(this.schedulePeriod, salesforceSourceRequest.schedulePeriod) && Objects.equals(this.settings, salesforceSourceRequest.settings) && Objects.equals(this.selfUri, salesforceSourceRequest.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.integrationId, this.schedulePeriod, this.settings, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SalesforceSourceRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    schedulePeriod: ").append(this.toIndentedString(this.schedulePeriod)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

