/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Information about a public message.")
public class OpenSocialMediaPublicMetadata
implements Serializable {
    private String rootId = null;
    private String replyToId = null;
    private String source = null;
    private String url = null;

    public OpenSocialMediaPublicMetadata() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public OpenSocialMediaPublicMetadata rootId(String rootId) {
        this.rootId = rootId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The id of the root public message.")
    @JsonProperty(value="rootId")
    public String getRootId() {
        return this.rootId;
    }

    public void setRootId(String rootId) {
        this.rootId = rootId;
    }

    public OpenSocialMediaPublicMetadata replyToId(String replyToId) {
        this.replyToId = replyToId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the message this public message is replying to.")
    @JsonProperty(value="replyToId")
    public String getReplyToId() {
        return this.replyToId;
    }

    public void setReplyToId(String replyToId) {
        this.replyToId = replyToId;
    }

    public OpenSocialMediaPublicMetadata source(String source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(example="null", value="The source of the public message. Useful when there could be more than location. Channel specific, e.g., for Facebook it's a source page.")
    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public OpenSocialMediaPublicMetadata url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="null", value="The URL of the social post on the native platform.")
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenSocialMediaPublicMetadata openSocialMediaPublicMetadata = (OpenSocialMediaPublicMetadata)o;
        return Objects.equals(this.rootId, openSocialMediaPublicMetadata.rootId) && Objects.equals(this.replyToId, openSocialMediaPublicMetadata.replyToId) && Objects.equals(this.source, openSocialMediaPublicMetadata.source) && Objects.equals(this.url, openSocialMediaPublicMetadata.url);
    }

    public int hashCode() {
        return Objects.hash(this.rootId, this.replyToId, this.source, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenSocialMediaPublicMetadata {\n");
        sb.append("    rootId: ").append(this.toIndentedString(this.rootId)).append("\n");
        sb.append("    replyToId: ").append(this.toIndentedString(this.replyToId)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

