/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConversationContentAttachment;
import com.mypurecloud.sdk.v2.model.ConversationContentReaction;
import com.mypurecloud.sdk.v2.model.ConversationContentText;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Message content element.")
public class OpenSocialMediaMessageContent
implements Serializable {
    private ContentTypeEnum contentType = null;
    private ConversationContentAttachment attachment = null;
    private ConversationContentText text = null;
    private ConversationContentReaction reaction = null;

    public OpenSocialMediaMessageContent() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public OpenSocialMediaMessageContent contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of this content element.")
    @JsonProperty(value="contentType")
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public OpenSocialMediaMessageContent attachment(ConversationContentAttachment attachment) {
        this.attachment = attachment;
        return this;
    }

    @ApiModelProperty(example="null", value="Attachment content.")
    @JsonProperty(value="attachment")
    public ConversationContentAttachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(ConversationContentAttachment attachment) {
        this.attachment = attachment;
    }

    public OpenSocialMediaMessageContent text(ConversationContentText text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="A content type containing text.")
    @JsonProperty(value="text")
    public ConversationContentText getText() {
        return this.text;
    }

    public void setText(ConversationContentText text) {
        this.text = text;
    }

    public OpenSocialMediaMessageContent reaction(ConversationContentReaction reaction) {
        this.reaction = reaction;
        return this;
    }

    @ApiModelProperty(example="null", value="A set of reactions to a message.")
    @JsonProperty(value="reaction")
    public ConversationContentReaction getReaction() {
        return this.reaction;
    }

    public void setReaction(ConversationContentReaction reaction) {
        this.reaction = reaction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenSocialMediaMessageContent openSocialMediaMessageContent = (OpenSocialMediaMessageContent)o;
        return Objects.equals((Object)this.contentType, (Object)openSocialMediaMessageContent.contentType) && Objects.equals(this.attachment, openSocialMediaMessageContent.attachment) && Objects.equals(this.text, openSocialMediaMessageContent.text) && Objects.equals(this.reaction, openSocialMediaMessageContent.reaction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contentType, this.attachment, this.text, this.reaction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenSocialMediaMessageContent {\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    reaction: ").append(this.toIndentedString(this.reaction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ContentTypeEnumDeserializer.class)
    public static enum ContentTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ATTACHMENT("Attachment"),
        REACTIONS("Reactions"),
        TEXT("Text");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ContentTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ContentTypeEnum value : ContentTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ContentTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ContentTypeEnumDeserializer
    extends StdDeserializer<ContentTypeEnum> {
        public ContentTypeEnumDeserializer() {
            super(ContentTypeEnumDeserializer.class);
        }

        public ContentTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ContentTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

