/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.OpenInboundMessageContent;
import com.mypurecloud.sdk.v2.model.OpenInboundMessageMessagingChannel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Open Messaging rich media message structure")
public class OpenInboundNormalizedMessage
implements Serializable {
    private OpenInboundMessageMessagingChannel channel = null;
    private String text = null;
    private List<OpenInboundMessageContent> content = null;
    private Map<String, String> metadata = null;

    public OpenInboundNormalizedMessage() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.content = new ArrayList<OpenInboundMessageContent>();
        }
    }

    public OpenInboundNormalizedMessage channel(OpenInboundMessageMessagingChannel channel) {
        this.channel = channel;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Channel-specific information that describes the message and the message channel/provider.")
    @JsonProperty(value="channel")
    public OpenInboundMessageMessagingChannel getChannel() {
        return this.channel;
    }

    public void setChannel(OpenInboundMessageMessagingChannel channel) {
        this.channel = channel;
    }

    public OpenInboundNormalizedMessage text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="Message text.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public OpenInboundNormalizedMessage content(List<OpenInboundMessageContent> content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(example="null", value="List of content elements.")
    @JsonProperty(value="content")
    public List<OpenInboundMessageContent> getContent() {
        return this.content;
    }

    public void setContent(List<OpenInboundMessageContent> content) {
        this.content = content;
    }

    public OpenInboundNormalizedMessage metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional metadata about this message to capture non-channel specific data.")
    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenInboundNormalizedMessage openInboundNormalizedMessage = (OpenInboundNormalizedMessage)o;
        return Objects.equals(this.channel, openInboundNormalizedMessage.channel) && Objects.equals(this.text, openInboundNormalizedMessage.text) && Objects.equals(this.content, openInboundNormalizedMessage.content) && Objects.equals(this.metadata, openInboundNormalizedMessage.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.channel, this.text, this.content, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenInboundNormalizedMessage {\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

