/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Notification settings that handles messenger notifications")
public class NotificationsSettings
implements Serializable {
    private Boolean enabled = null;
    private NotificationContentTypeEnum notificationContentType = null;

    public NotificationsSettings() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public NotificationsSettings enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", value="The toggle to enable or disable notifications")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public NotificationsSettings notificationContentType(NotificationContentTypeEnum notificationContentType) {
        this.notificationContentType = notificationContentType;
        return this;
    }

    @ApiModelProperty(example="null", value="The notification content type settings for messenger")
    @JsonProperty(value="notificationContentType")
    public NotificationContentTypeEnum getNotificationContentType() {
        return this.notificationContentType;
    }

    public void setNotificationContentType(NotificationContentTypeEnum notificationContentType) {
        this.notificationContentType = notificationContentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationsSettings notificationsSettings = (NotificationsSettings)o;
        return Objects.equals(this.enabled, notificationsSettings.enabled) && Objects.equals((Object)this.notificationContentType, (Object)notificationsSettings.notificationContentType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.notificationContentType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NotificationsSettings {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    notificationContentType: ").append(this.toIndentedString((Object)this.notificationContentType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=NotificationContentTypeEnumDeserializer.class)
    public static enum NotificationContentTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INCLUDEMESSAGESCONTENT("IncludeMessagesContent"),
        EXCLUDEMESSAGESCONTENT("ExcludeMessagesContent");

        private String value;

        private NotificationContentTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static NotificationContentTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (NotificationContentTypeEnum value : NotificationContentTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return NotificationContentTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class NotificationContentTypeEnumDeserializer
    extends StdDeserializer<NotificationContentTypeEnum> {
        public NotificationContentTypeEnumDeserializer() {
            super(NotificationContentTypeEnumDeserializer.class);
        }

        public NotificationContentTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return NotificationContentTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

