/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.NluUtteranceSegment;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class NluUtterance
implements Serializable {
    private String id = null;
    private SourceEnum source = null;
    private List<NluUtteranceSegment> segments = null;

    public NluUtterance() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.segments = new ArrayList<NluUtteranceSegment>();
        }
    }

    @ApiModelProperty(example="null", value="ID of the utterance.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public NluUtterance source(SourceEnum source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(example="null", value="The source of the utterance.")
    @JsonProperty(value="source")
    public SourceEnum getSource() {
        return this.source;
    }

    public void setSource(SourceEnum source) {
        this.source = source;
    }

    public NluUtterance segments(List<NluUtteranceSegment> segments) {
        this.segments = segments;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The list of segments that that constitute this utterance for the given intent.")
    @JsonProperty(value="segments")
    public List<NluUtteranceSegment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<NluUtteranceSegment> segments) {
        this.segments = segments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NluUtterance nluUtterance = (NluUtterance)o;
        return Objects.equals(this.id, nluUtterance.id) && Objects.equals((Object)this.source, (Object)nluUtterance.source) && Objects.equals(this.segments, nluUtterance.segments);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.source, this.segments});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NluUtterance {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    segments: ").append(this.toIndentedString(this.segments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SourceEnumDeserializer.class)
    public static enum SourceEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GENERATED("Generated"),
        USER("User");

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SourceEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SourceEnum value : SourceEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SourceEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SourceEnumDeserializer
    extends StdDeserializer<SourceEnum> {
        public SourceEnumDeserializer() {
            super(SourceEnumDeserializer.class);
        }

        public SourceEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SourceEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

