/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LocaleHealth
implements Serializable {
    private Float overallScore = null;
    private Long issueCount = null;
    private List<StaticValidationResultsEnum> staticValidationResults = null;

    public LocaleHealth() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.staticValidationResults = new ArrayList<StaticValidationResultsEnum>();
        }
    }

    public LocaleHealth overallScore(Float overallScore) {
        this.overallScore = overallScore;
        return this;
    }

    @ApiModelProperty(example="null", value="Overall health score for the intent.")
    @JsonProperty(value="overallScore")
    public Float getOverallScore() {
        return this.overallScore;
    }

    public void setOverallScore(Float overallScore) {
        this.overallScore = overallScore;
    }

    public LocaleHealth issueCount(Long issueCount) {
        this.issueCount = issueCount;
        return this;
    }

    @ApiModelProperty(example="null", value="Number of issues found in the intent.")
    @JsonProperty(value="issueCount")
    public Long getIssueCount() {
        return this.issueCount;
    }

    public void setIssueCount(Long issueCount) {
        this.issueCount = issueCount;
    }

    public LocaleHealth staticValidationResults(List<StaticValidationResultsEnum> staticValidationResults) {
        this.staticValidationResults = staticValidationResults;
        return this;
    }

    @ApiModelProperty(example="null", value="Validation results for the intent.")
    @JsonProperty(value="staticValidationResults")
    public List<StaticValidationResultsEnum> getStaticValidationResults() {
        return this.staticValidationResults;
    }

    public void setStaticValidationResults(List<StaticValidationResultsEnum> staticValidationResults) {
        this.staticValidationResults = staticValidationResults;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocaleHealth localeHealth = (LocaleHealth)o;
        return Objects.equals(this.overallScore, localeHealth.overallScore) && Objects.equals(this.issueCount, localeHealth.issueCount) && Objects.equals(this.staticValidationResults, localeHealth.staticValidationResults);
    }

    public int hashCode() {
        return Objects.hash(this.overallScore, this.issueCount, this.staticValidationResults);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LocaleHealth {\n");
        sb.append("    overallScore: ").append(this.toIndentedString(this.overallScore)).append("\n");
        sb.append("    issueCount: ").append(this.toIndentedString(this.issueCount)).append("\n");
        sb.append("    staticValidationResults: ").append(this.toIndentedString(this.staticValidationResults)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StaticValidationResultsEnumDeserializer.class)
    public static enum StaticValidationResultsEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TOOFEWUTTERANCES("TooFewUtterances"),
        TOOMANYUTTERANCES("TooManyUtterances"),
        UTTERANCETOOSHORT("UtteranceTooShort"),
        UTTERANCETOOLONG("UtteranceTooLong");

        private String value;

        private StaticValidationResultsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StaticValidationResultsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StaticValidationResultsEnum value : StaticValidationResultsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StaticValidationResultsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StaticValidationResultsEnumDeserializer
    extends StdDeserializer<StaticValidationResultsEnum> {
        public StaticValidationResultsEnumDeserializer() {
            super(StaticValidationResultsEnumDeserializer.class);
        }

        public StaticValidationResultsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StaticValidationResultsEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

