/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DocumentQuery;
import com.mypurecloud.sdk.v2.model.DocumentQueryInterval;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class KnowledgeDocumentQuery
implements Serializable {
    private Integer pageSize = null;
    private Integer pageNumber = null;
    private Boolean includeDraftDocuments = null;
    private DocumentQueryInterval interval = null;
    private DocumentQuery filter = null;
    private IncludeVariationsEnum includeVariations = null;
    private SortOrderEnum sortOrder = null;
    private SortByEnum sortBy = null;

    public KnowledgeDocumentQuery() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public KnowledgeDocumentQuery pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", value="Page size of the returned results.")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public KnowledgeDocumentQuery pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Page number of the returned results.")
    @JsonProperty(value="pageNumber")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public KnowledgeDocumentQuery includeDraftDocuments(Boolean includeDraftDocuments) {
        this.includeDraftDocuments = includeDraftDocuments;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether the results would also include draft documents.")
    @JsonProperty(value="includeDraftDocuments")
    public Boolean getIncludeDraftDocuments() {
        return this.includeDraftDocuments;
    }

    public void setIncludeDraftDocuments(Boolean includeDraftDocuments) {
        this.includeDraftDocuments = includeDraftDocuments;
    }

    public KnowledgeDocumentQuery interval(DocumentQueryInterval interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", value="Retrieves the documents created/modified/published in specified date and time range.")
    @JsonProperty(value="interval")
    public DocumentQueryInterval getInterval() {
        return this.interval;
    }

    public void setInterval(DocumentQueryInterval interval) {
        this.interval = interval;
    }

    public KnowledgeDocumentQuery filter(DocumentQuery filter) {
        this.filter = filter;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Filter for the document query.")
    @JsonProperty(value="filter")
    public DocumentQuery getFilter() {
        return this.filter;
    }

    public void setFilter(DocumentQuery filter) {
        this.filter = filter;
    }

    public KnowledgeDocumentQuery includeVariations(IncludeVariationsEnum includeVariations) {
        this.includeVariations = includeVariations;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates which document variations to include in returned documents. All: all variations regardless of the filter expression; AllMatching: all variations that match the filter expression; SingleMostRelevant: single variation that matches the filter expression and has the highest priority. The default is All.")
    @JsonProperty(value="includeVariations")
    public IncludeVariationsEnum getIncludeVariations() {
        return this.includeVariations;
    }

    public void setIncludeVariations(IncludeVariationsEnum includeVariations) {
        this.includeVariations = includeVariations;
    }

    public KnowledgeDocumentQuery sortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    @ApiModelProperty(example="null", value="The sort order for results.")
    @JsonProperty(value="sortOrder")
    public SortOrderEnum getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrderEnum sortOrder) {
        this.sortOrder = sortOrder;
    }

    public KnowledgeDocumentQuery sortBy(SortByEnum sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The field in the documents that you want to sort the results by.")
    @JsonProperty(value="sortBy")
    public SortByEnum getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(SortByEnum sortBy) {
        this.sortBy = sortBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeDocumentQuery knowledgeDocumentQuery = (KnowledgeDocumentQuery)o;
        return Objects.equals(this.pageSize, knowledgeDocumentQuery.pageSize) && Objects.equals(this.pageNumber, knowledgeDocumentQuery.pageNumber) && Objects.equals(this.includeDraftDocuments, knowledgeDocumentQuery.includeDraftDocuments) && Objects.equals(this.interval, knowledgeDocumentQuery.interval) && Objects.equals(this.filter, knowledgeDocumentQuery.filter) && Objects.equals((Object)this.includeVariations, (Object)knowledgeDocumentQuery.includeVariations) && Objects.equals((Object)this.sortOrder, (Object)knowledgeDocumentQuery.sortOrder) && Objects.equals((Object)this.sortBy, (Object)knowledgeDocumentQuery.sortBy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pageSize, this.pageNumber, this.includeDraftDocuments, this.interval, this.filter, this.includeVariations, this.sortOrder, this.sortBy});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeDocumentQuery {\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    includeDraftDocuments: ").append(this.toIndentedString(this.includeDraftDocuments)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    includeVariations: ").append(this.toIndentedString((Object)this.includeVariations)).append("\n");
        sb.append("    sortOrder: ").append(this.toIndentedString((Object)this.sortOrder)).append("\n");
        sb.append("    sortBy: ").append(this.toIndentedString((Object)this.sortBy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=IncludeVariationsEnumDeserializer.class)
    public static enum IncludeVariationsEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALL("All"),
        ALLMATCHING("AllMatching"),
        SINGLEMOSTRELEVANT("SingleMostRelevant");

        private String value;

        private IncludeVariationsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static IncludeVariationsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (IncludeVariationsEnum value : IncludeVariationsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return IncludeVariationsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SortOrderEnumDeserializer.class)
    public static enum SortOrderEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASC("Asc"),
        DESC("Desc");

        private String value;

        private SortOrderEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SortOrderEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SortOrderEnum value : SortOrderEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SortOrderEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SortByEnumDeserializer.class)
    public static enum SortByEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DATECREATED("DateCreated"),
        DATEMODIFIED("DateModified"),
        CATEGORYNAME("CategoryName"),
        LABELNAME("LabelName"),
        VIEWCOUNT("ViewCount");

        private String value;

        private SortByEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SortByEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SortByEnum value : SortByEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SortByEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SortByEnumDeserializer
    extends StdDeserializer<SortByEnum> {
        public SortByEnumDeserializer() {
            super(SortByEnumDeserializer.class);
        }

        public SortByEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SortByEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class SortOrderEnumDeserializer
    extends StdDeserializer<SortOrderEnum> {
        public SortOrderEnumDeserializer() {
            super(SortOrderEnumDeserializer.class);
        }

        public SortOrderEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SortOrderEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class IncludeVariationsEnumDeserializer
    extends StdDeserializer<IncludeVariationsEnum> {
        public IncludeVariationsEnumDeserializer() {
            super(IncludeVariationsEnumDeserializer.class);
        }

        public IncludeVariationsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return IncludeVariationsEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

