/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AdditionalLanguagesIntent;
import com.mypurecloud.sdk.v2.model.NamedEntityTypeBinding;
import com.mypurecloud.sdk.v2.model.NluUtterance;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IntentDefinition
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private List<NamedEntityTypeBinding> entityTypeBindings = null;
    private List<String> entityNameReferences = null;
    private List<NluUtterance> utterances = null;
    private Map<String, AdditionalLanguagesIntent> additionalLanguages = null;

    public IntentDefinition() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.entityTypeBindings = new ArrayList<NamedEntityTypeBinding>();
            this.entityNameReferences = new ArrayList<String>();
            this.utterances = new ArrayList<NluUtterance>();
        }
    }

    @ApiModelProperty(example="null", value="ID of the intent.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public IntentDefinition name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the intent.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IntentDefinition description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the intent.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public IntentDefinition entityTypeBindings(List<NamedEntityTypeBinding> entityTypeBindings) {
        this.entityTypeBindings = entityTypeBindings;
        return this;
    }

    @ApiModelProperty(example="null", value="The bindings for the named entity types used in this intent.This field is mutually exclusive with entityNameReferences and entities")
    @JsonProperty(value="entityTypeBindings")
    public List<NamedEntityTypeBinding> getEntityTypeBindings() {
        return this.entityTypeBindings;
    }

    public void setEntityTypeBindings(List<NamedEntityTypeBinding> entityTypeBindings) {
        this.entityTypeBindings = entityTypeBindings;
    }

    @ApiModelProperty(example="null", value="The references for the named entity used in this intent.This field is mutually exclusive with entityTypeBindings")
    @JsonProperty(value="entityNameReferences")
    public List<String> getEntityNameReferences() {
        return this.entityNameReferences;
    }

    public IntentDefinition utterances(List<NluUtterance> utterances) {
        this.utterances = utterances;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The utterances that act as training phrases for the intent.")
    @JsonProperty(value="utterances")
    public List<NluUtterance> getUtterances() {
        return this.utterances;
    }

    public void setUtterances(List<NluUtterance> utterances) {
        this.utterances = utterances;
    }

    public IntentDefinition additionalLanguages(Map<String, AdditionalLanguagesIntent> additionalLanguages) {
        this.additionalLanguages = additionalLanguages;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional languages for intents")
    @JsonProperty(value="additionalLanguages")
    public Map<String, AdditionalLanguagesIntent> getAdditionalLanguages() {
        return this.additionalLanguages;
    }

    public void setAdditionalLanguages(Map<String, AdditionalLanguagesIntent> additionalLanguages) {
        this.additionalLanguages = additionalLanguages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntentDefinition intentDefinition = (IntentDefinition)o;
        return Objects.equals(this.id, intentDefinition.id) && Objects.equals(this.name, intentDefinition.name) && Objects.equals(this.description, intentDefinition.description) && Objects.equals(this.entityTypeBindings, intentDefinition.entityTypeBindings) && Objects.equals(this.entityNameReferences, intentDefinition.entityNameReferences) && Objects.equals(this.utterances, intentDefinition.utterances) && Objects.equals(this.additionalLanguages, intentDefinition.additionalLanguages);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.entityTypeBindings, this.entityNameReferences, this.utterances, this.additionalLanguages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IntentDefinition {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    entityTypeBindings: ").append(this.toIndentedString(this.entityTypeBindings)).append("\n");
        sb.append("    entityNameReferences: ").append(this.toIndentedString(this.entityNameReferences)).append("\n");
        sb.append("    utterances: ").append(this.toIndentedString(this.utterances)).append("\n");
        sb.append("    additionalLanguages: ").append(this.toIndentedString(this.additionalLanguages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

