/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.EmailAddress;
import com.mypurecloud.sdk.v2.model.QueueEmailAddress;
import com.mypurecloud.sdk.v2.model.Signature;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class InboundRoute
implements Serializable {
    private String id = null;
    private String name = null;
    private String pattern = null;
    private DomainEntityRef queue = null;
    private Integer priority = null;
    private List<DomainEntityRef> skills = null;
    private DomainEntityRef language = null;
    private String fromName = null;
    private String fromEmail = null;
    private DomainEntityRef flow = null;
    private QueueEmailAddress replyEmailAddress = null;
    private List<EmailAddress> autoBcc = null;
    private DomainEntityRef spamFlow = null;
    private Signature signature = null;
    private HistoryInclusionEnum historyInclusion = null;
    private Boolean allowMultipleActions = null;
    private String selfUri = null;

    public InboundRoute() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.skills = new ArrayList<DomainEntityRef>();
            this.autoBcc = new ArrayList<EmailAddress>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public InboundRoute name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InboundRoute pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The search pattern that the mailbox name should match.")
    @JsonProperty(value="pattern")
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public InboundRoute queue(DomainEntityRef queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="The queue to route the emails to.")
    @JsonProperty(value="queue")
    public DomainEntityRef getQueue() {
        return this.queue;
    }

    public void setQueue(DomainEntityRef queue) {
        this.queue = queue;
    }

    public InboundRoute priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(example="null", value="The priority to use for routing.")
    @JsonProperty(value="priority")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public InboundRoute skills(List<DomainEntityRef> skills) {
        this.skills = skills;
        return this;
    }

    @ApiModelProperty(example="null", value="The skills to use for routing.")
    @JsonProperty(value="skills")
    public List<DomainEntityRef> getSkills() {
        return this.skills;
    }

    public void setSkills(List<DomainEntityRef> skills) {
        this.skills = skills;
    }

    public InboundRoute language(DomainEntityRef language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", value="The language to use for routing.")
    @JsonProperty(value="language")
    public DomainEntityRef getLanguage() {
        return this.language;
    }

    public void setLanguage(DomainEntityRef language) {
        this.language = language;
    }

    public InboundRoute fromName(String fromName) {
        this.fromName = fromName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The sender name to use for outgoing replies.")
    @JsonProperty(value="fromName")
    public String getFromName() {
        return this.fromName;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public InboundRoute fromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
        return this;
    }

    @ApiModelProperty(example="null", value="The sender email to use for outgoing replies.")
    @JsonProperty(value="fromEmail")
    public String getFromEmail() {
        return this.fromEmail;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public InboundRoute flow(DomainEntityRef flow) {
        this.flow = flow;
        return this;
    }

    @ApiModelProperty(example="null", value="The flow to use for processing the email.")
    @JsonProperty(value="flow")
    public DomainEntityRef getFlow() {
        return this.flow;
    }

    public void setFlow(DomainEntityRef flow) {
        this.flow = flow;
    }

    public InboundRoute replyEmailAddress(QueueEmailAddress replyEmailAddress) {
        this.replyEmailAddress = replyEmailAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="The route to use for email replies.")
    @JsonProperty(value="replyEmailAddress")
    public QueueEmailAddress getReplyEmailAddress() {
        return this.replyEmailAddress;
    }

    public void setReplyEmailAddress(QueueEmailAddress replyEmailAddress) {
        this.replyEmailAddress = replyEmailAddress;
    }

    public InboundRoute autoBcc(List<EmailAddress> autoBcc) {
        this.autoBcc = autoBcc;
        return this;
    }

    @ApiModelProperty(example="null", value="The recipients that should be automatically blind copied on outbound emails associated with this InboundRoute.")
    @JsonProperty(value="autoBcc")
    public List<EmailAddress> getAutoBcc() {
        return this.autoBcc;
    }

    public void setAutoBcc(List<EmailAddress> autoBcc) {
        this.autoBcc = autoBcc;
    }

    public InboundRoute spamFlow(DomainEntityRef spamFlow) {
        this.spamFlow = spamFlow;
        return this;
    }

    @ApiModelProperty(example="null", value="The flow to use for processing inbound emails that have been marked as spam.")
    @JsonProperty(value="spamFlow")
    public DomainEntityRef getSpamFlow() {
        return this.spamFlow;
    }

    public void setSpamFlow(DomainEntityRef spamFlow) {
        this.spamFlow = spamFlow;
    }

    public InboundRoute signature(Signature signature) {
        this.signature = signature;
        return this;
    }

    @ApiModelProperty(example="null", value="The configuration for the canned response signature that will be appended to outbound emails sent via this route")
    @JsonProperty(value="signature")
    public Signature getSignature() {
        return this.signature;
    }

    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    public InboundRoute historyInclusion(HistoryInclusionEnum historyInclusion) {
        this.historyInclusion = historyInclusion;
        return this;
    }

    @ApiModelProperty(example="null", value="The configuration to indicate how the history of a conversation has to be included in a draft")
    @JsonProperty(value="historyInclusion")
    public HistoryInclusionEnum getHistoryInclusion() {
        return this.historyInclusion;
    }

    public void setHistoryInclusion(HistoryInclusionEnum historyInclusion) {
        this.historyInclusion = historyInclusion;
    }

    public InboundRoute allowMultipleActions(Boolean allowMultipleActions) {
        this.allowMultipleActions = allowMultipleActions;
        return this;
    }

    @ApiModelProperty(example="null", value="Control if multiple actions are allowed on this route. When true the disconnect has to be done manually. When false a conversation will be disconnected by the system after every action")
    @JsonProperty(value="allowMultipleActions")
    public Boolean getAllowMultipleActions() {
        return this.allowMultipleActions;
    }

    public void setAllowMultipleActions(Boolean allowMultipleActions) {
        this.allowMultipleActions = allowMultipleActions;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InboundRoute inboundRoute = (InboundRoute)o;
        return Objects.equals(this.id, inboundRoute.id) && Objects.equals(this.name, inboundRoute.name) && Objects.equals(this.pattern, inboundRoute.pattern) && Objects.equals(this.queue, inboundRoute.queue) && Objects.equals(this.priority, inboundRoute.priority) && Objects.equals(this.skills, inboundRoute.skills) && Objects.equals(this.language, inboundRoute.language) && Objects.equals(this.fromName, inboundRoute.fromName) && Objects.equals(this.fromEmail, inboundRoute.fromEmail) && Objects.equals(this.flow, inboundRoute.flow) && Objects.equals(this.replyEmailAddress, inboundRoute.replyEmailAddress) && Objects.equals(this.autoBcc, inboundRoute.autoBcc) && Objects.equals(this.spamFlow, inboundRoute.spamFlow) && Objects.equals(this.signature, inboundRoute.signature) && Objects.equals((Object)this.historyInclusion, (Object)inboundRoute.historyInclusion) && Objects.equals(this.allowMultipleActions, inboundRoute.allowMultipleActions) && Objects.equals(this.selfUri, inboundRoute.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.pattern, this.queue, this.priority, this.skills, this.language, this.fromName, this.fromEmail, this.flow, this.replyEmailAddress, this.autoBcc, this.spamFlow, this.signature, this.historyInclusion, this.allowMultipleActions, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InboundRoute {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    pattern: ").append(this.toIndentedString(this.pattern)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    skills: ").append(this.toIndentedString(this.skills)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    fromName: ").append(this.toIndentedString(this.fromName)).append("\n");
        sb.append("    fromEmail: ").append(this.toIndentedString(this.fromEmail)).append("\n");
        sb.append("    flow: ").append(this.toIndentedString(this.flow)).append("\n");
        sb.append("    replyEmailAddress: ").append(this.toIndentedString(this.replyEmailAddress)).append("\n");
        sb.append("    autoBcc: ").append(this.toIndentedString(this.autoBcc)).append("\n");
        sb.append("    spamFlow: ").append(this.toIndentedString(this.spamFlow)).append("\n");
        sb.append("    signature: ").append(this.toIndentedString(this.signature)).append("\n");
        sb.append("    historyInclusion: ").append(this.toIndentedString((Object)this.historyInclusion)).append("\n");
        sb.append("    allowMultipleActions: ").append(this.toIndentedString(this.allowMultipleActions)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=HistoryInclusionEnumDeserializer.class)
    public static enum HistoryInclusionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INCLUDE("Include"),
        EXCLUDE("Exclude"),
        OPTIONAL("Optional");

        private String value;

        private HistoryInclusionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static HistoryInclusionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (HistoryInclusionEnum value : HistoryInclusionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return HistoryInclusionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class HistoryInclusionEnumDeserializer
    extends StdDeserializer<HistoryInclusionEnum> {
        public HistoryInclusionEnumDeserializer() {
            super(HistoryInclusionEnumDeserializer.class);
        }

        public HistoryInclusionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return HistoryInclusionEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

